/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.forge.config;

import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ConfigHandlerForge
extends ConfigHandler {
    private IdentityHashMap<ConfigBase.Category.Entry, ForgeConfigSpec.ConfigValue> entryToValues;
    private ModConfig modConfig;

    private static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ConfigHandlerForge.onServerConnect();
    }

    private static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ConfigHandlerForge.onServerDisconnect();
    }

    public ConfigHandlerForge(ConfigBase config) {
        super(config);
    }

    @Override
    public void init() {
        this.entryToValues = new IdentityHashMap();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        boolean inCat = false;
        for (ConfigBase.Category cat : this.config.categories) {
            if (inCat) {
                builder.pop();
            }
            inCat = true;
            if (cat.comment != null) {
                builder.comment(cat.comment);
            }
            if (cat.commentKey != null) {
                builder.translation(cat.commentKey);
            }
            builder.push(cat.name);
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                Prop prop;
                if (e.prop.skip()) continue;
                if (e.comment != null) {
                    builder.comment(e.comment);
                }
                if (e.commentKey != null) {
                    builder.translation(e.commentKey);
                }
                if ((prop = e.prop).needsRestart()) {
                    builder.worldRestart();
                }
                ForgeConfigSpec.BooleanValue value = null;
                Class<?> clz = e.field.getType();
                String fieldName = e.field.getName();
                try {
                    Object o = e.field.get(this.config);
                    if (clz == Integer.TYPE) {
                        value = builder.defineInRange(fieldName, ((Integer)o).intValue(), prop.intBool() ? 0 : (prop.min() == -1.7976931348623157E308 ? Integer.MIN_VALUE : (int)prop.min()), prop.intBool() ? 1 : (prop.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)prop.max()));
                    } else if (clz == Double.TYPE) {
                        value = builder.defineInRange(fieldName, ((Double)o).doubleValue(), prop.min(), prop.max());
                    } else if (clz == Boolean.TYPE) {
                        value = builder.define(fieldName, ((Boolean)o).booleanValue());
                    } else if (clz == String.class) {
                        if (prop.values().length != 1 || !prop.values()[0].isEmpty()) {
                            value = builder.defineInList(fieldName, (Object)((String)o), Arrays.asList(prop.values()));
                        } else if (prop.validator().equals("undefined") || prop.validator().isEmpty()) {
                            value = builder.define(fieldName, (Object)((String)o));
                        } else {
                            method = this.config.getValidatorMethod(prop.validator());
                            value = builder.define(fieldName, (Object)((String)o), x -> this.config.validate(method, x));
                        }
                    } else if (clz.isEnum()) {
                        value = builder.defineEnum(fieldName, (Enum)o);
                    } else if (o instanceof List) {
                        if (prop.validator().equals("undefined") || prop.validator().isEmpty()) {
                            value = builder.defineList(fieldName, (List)o, x -> true);
                        } else {
                            method = this.config.getValidatorMethod(prop.validator());
                            value = builder.defineList(fieldName, (List)o, x -> this.config.validate(method, x));
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error with creating field {} for config {}", new Object[]{fieldName, this.config.getFileName(), ex});
                }
                if (value != null) {
                    this.entryToValues.put(e, (ForgeConfigSpec.ConfigValue)value);
                    continue;
                }
                throw new RuntimeException("Value should never be null");
            }
        }
        if (!this.config.categories.isEmpty()) {
            builder.pop();
        }
        this.modConfig = new ModConfig(this.config.getConfigType() == ConfigBase.Type.COMMON ? ModConfig.Type.COMMON : (this.config.getConfigType() == ConfigBase.Type.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.SERVER), (IConfigSpec)builder.build(), ModLoadingContext.get().getActiveContainer(), this.config.getFileName());
        ModLoadingContext.get().getActiveContainer().addConfig(this.modConfig);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
        this.config.setSaveMethod(() -> {
            IConfigSpec modSpec = this.modConfig.getSpec();
            ForgeConfigSpec forgeSpec = null;
            if (modSpec instanceof ForgeConfigSpec) {
                ForgeConfigSpec spec;
                forgeSpec = spec = (ForgeConfigSpec)modSpec;
            } else if (modSpec.getClass().getName().equals("fuzs.nightconfigfixes.config.ConfigSpecWrapper")) {
                Class<?> clz = modSpec.getClass();
                try {
                    Method getSpec = clz.getDeclaredMethod("getSpec", new Class[0]);
                    getSpec.setAccessible(true);
                    forgeSpec = (ForgeConfigSpec)getSpec.invoke((Object)modSpec, new Object[0]);
                }
                catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InaccessibleObjectException | InvocationTargetException e) {
                    iChunUtil.LOGGER.error("Error getting spec from ConfigSpecWrapper", (Throwable)e);
                }
            } else {
                iChunUtil.LOGGER.warn("We don't know how to handle this config type, configs won't save properly: {}", (Object)modSpec.getClass().getName());
            }
            if (forgeSpec != null && forgeSpec.isLoaded() && this.updateConfigValuesFromFields()) {
                forgeSpec.save();
            }
        });
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getFileName().equals(this.config.getFileName())) {
            this.checkForChangesFromFile(false);
            this.config.onConfigLoaded();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getFileName().equals(this.config.getFileName())) {
            this.checkForChangesFromFile(true);
        }
    }

    @Override
    protected void checkForChangesFromFile(boolean reload) {
        for (ConfigBase.Category cat : this.config.categories) {
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                if (e.prop.skip()) continue;
                ForgeConfigSpec.ConfigValue configValue = this.entryToValues.get(e);
                Object o = configValue.get();
                try {
                    e.field.setAccessible(true);
                    Object oldObj = e.field.get(this.config);
                    if (o.equals(oldObj)) continue;
                    e.field.set(this.config, o);
                    if (!reload) continue;
                    this.config.onPropertyChanged(true, e.field.getName(), e.field, oldObj, o);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error with updating field {} for config value {} for config {}", new Object[]{e.field.getName(), o, this.config.getFileName(), ex});
                }
            }
        }
    }

    private boolean updateConfigValuesFromFields() {
        boolean dirty = false;
        for (ConfigBase.Category cat : this.config.categories) {
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                if (e.prop.skip()) continue;
                ForgeConfigSpec.ConfigValue configValue = this.entryToValues.get(e);
                Object o = configValue.get();
                try {
                    e.field.setAccessible(true);
                    Object oldObj = e.field.get(this.config);
                    if (o.equals(oldObj)) continue;
                    configValue.set(oldObj);
                    dirty = true;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error with updating field {} for config value {} for config {}", new Object[]{e.field.getName(), o, this.config.getFileName(), ex});
                }
            }
        }
        return dirty;
    }

    static {
        if (iChunUtil.d().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(ConfigHandlerForge::onPlayerLoggedInEvent);
            MinecraftForge.EVENT_BUS.addListener(ConfigHandlerForge::onPlayerLoggedOutEvent);
        }
    }
}

