/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.forge.client;

import me.ichun.mods.ichunutil.client.core.EventHandlerClient;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.loader.event.EventListener;
import me.ichun.mods.ichunutil.loader.forge.event.client.ClientSystemChatEvent;
import me.ichun.mods.ichunutil.loader.forge.event.client.OverlayChangeEvent;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerClientForge
extends EventHandlerClient {
    @Override
    public void registerKeyMapping(KeyMapping key, String ... conflictContext) {
        Object keyConflictContext;
        if (!KeyBind.areKeyConflictContextsRegistered()) {
            KeyBind.registerKeyConflictContext("in_game_modifier_sensitive", new IKeyConflictContext(){

                public boolean isActive() {
                    return !KeyConflictContext.GUI.isActive();
                }

                public boolean conflicts(IKeyConflictContext other) {
                    return this == other;
                }
            });
        }
        if (conflictContext.length > 0 && (keyConflictContext = KeyBind.getKeyConflictContext(conflictContext[0])) != null) {
            key.setKeyConflictContext((IKeyConflictContext)keyConflictContext);
        }
        Minecraft.m_91087_().f_91066_.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.m_91087_().f_91066_.f_92059_, (Object)key);
    }

    @Override
    protected void registerAsClientTickStartListener(EventListener<Minecraft> eventListener) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.ClientTickEvent.class, event -> {
            if (event.phase == TickEvent.Phase.START) {
                eventListener.trigger(Minecraft.m_91087_());
            }
        });
    }

    @Override
    protected void registerAsClientTickEndListener(EventListener<Minecraft> eventListener) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.ClientTickEvent.class, event -> {
            if (event.phase == TickEvent.Phase.END) {
                eventListener.trigger(Minecraft.m_91087_());
            }
        });
    }

    @Override
    protected void registerAsOnClientConnectListener(EventListener<Minecraft> eventListener) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ClientPlayerNetworkEvent.LoggedInEvent.class, event -> eventListener.trigger(Minecraft.m_91087_()));
    }

    @Override
    protected void registerAsOnClientDisconnectListener(EventListener<Minecraft> eventListener) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ClientPlayerNetworkEvent.LoggedOutEvent.class, event -> eventListener.trigger(Minecraft.m_91087_()));
    }

    @Override
    public boolean fireClientHandleSystemMessage(Component message, boolean isOverlay) {
        return MinecraftForge.EVENT_BUS.post((Event)new ClientSystemChatEvent(message, isOverlay));
    }

    @Override
    public void fireOverlayChange(@Nullable Overlay currentOverlay, @Nullable Overlay newOverlay) {
        MinecraftForge.EVENT_BUS.post((Event)new OverlayChangeEvent(currentOverlay, newOverlay));
    }
}

