/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.util;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.common.iChunUtil;

public class WatchServiceThread
extends Thread {
    private static final Map<Path, WatchServiceThread> WATCH_SERVICES = Collections.synchronizedMap(new HashMap());
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final Path watchDir;
    private final Map<String, Consumer<String>> toWatch = Collections.synchronizedMap(new HashMap());
    private long sleepTime = 1000L;

    public WatchServiceThread(Path path) {
        this.setName("iChunUtil File Watcher Service");
        this.setDaemon(true);
        this.watchDir = path;
    }

    public WatchServiceThread setSleepTime(long l) {
        this.sleepTime = Math.min(l, this.sleepTime);
        return this;
    }

    public boolean isStopped() {
        return this.stop.get();
    }

    public void stopThread() {
        this.stop.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToWatch(String s, Consumer<String> onChange) {
        Map<String, Consumer<String>> map = this.toWatch;
        synchronized (map) {
            this.toWatch.put(s, onChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileToWatch(String s) {
        Map<String, Consumer<String>> map = this.toWatch;
        synchronized (map) {
            this.toWatch.remove(s);
            if (this.toWatch.isEmpty()) {
                this.stopThread();
                Map<Path, WatchServiceThread> map2 = WATCH_SERVICES;
                synchronized (map2) {
                    WATCH_SERVICES.remove(this.watchDir);
                }
            }
        }
    }

    @Override
    public void run() {
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            this.watchDir.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            while (!this.isStopped()) {
                WatchKey key;
                try {
                    key = watcher.poll(25L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (watcher != null) {
                        watcher.close();
                    }
                    return;
                }
                if (key == null) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep(100L);
                for (WatchEvent<?> event : key.pollEvents()) {
                    boolean valid;
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        Thread.yield();
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY && this.toWatch.containsKey(filename.toString())) {
                        this.toWatch.get(filename.toString()).accept(filename.toString());
                    }
                    if (valid = key.reset()) continue;
                    break;
                }
                Thread.sleep(this.sleepTime);
            }
        }
        catch (Throwable e) {
            iChunUtil.LOGGER.error("Error with watch service", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WatchServiceThread watchFile(Path file, Consumer<String> onChanged) {
        WatchServiceThread watchServiceThread;
        Map<Path, WatchServiceThread> map = WATCH_SERVICES;
        synchronized (map) {
            watchServiceThread = WATCH_SERVICES.computeIfAbsent(file.getParent(), k -> {
                WatchServiceThread thread = new WatchServiceThread(file.getParent());
                thread.start();
                return thread;
            });
            watchServiceThread.addFileToWatch(file.getFileName().toString(), onChanged);
        }
        return watchServiceThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopWatchFile(Path file) {
        Map<Path, WatchServiceThread> map = WATCH_SERVICES;
        synchronized (map) {
            if (WATCH_SERVICES.containsKey(file.getParent())) {
                WatchServiceThread thread = WATCH_SERVICES.get(file.getParent());
                thread.removeFileToWatch(file.getFileName().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopWatchFolder(Path folder) {
        Map<Path, WatchServiceThread> map = WATCH_SERVICES;
        synchronized (map) {
            WatchServiceThread watchServiceThread = WATCH_SERVICES.get(folder);
            if (watchServiceThread != null) {
                watchServiceThread.stopThread();
                WATCH_SERVICES.remove(folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminateWatchServices() {
        Map<Path, WatchServiceThread> map = WATCH_SERVICES;
        synchronized (map) {
            WATCH_SERVICES.forEach((k, v) -> v.stopThread());
            WATCH_SERVICES.clear();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(WatchServiceThread::terminateWatchServices));
    }
}

