/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.base.Function;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.item.ModItem;

@OnlyIn(value=Dist.CLIENT)
public final class TooltipEvents {
    private static ItemStack lastStack;
    private static CompoundTag lastNBT;
    private static Component lastFormatted;
    private static Function<CompoundTag, Component> formatter;
    private static boolean firstSeenDebugTooltip;
    public static final ClickEvent disableClickEvent;

    private TooltipEvents() {
    }

    public static void globalTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flag);
        }
    }

    public static void debugTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        List<String> tags;
        if (!Kiwi.areTagsUpdated() || !flag.m_7050_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (stack != lastStack && minecraft.f_91074_ != null && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292)) {
            lastStack = stack;
            Object data = stack.m_41783_();
            TextComponent itextcomponent = new TextComponent(stack.m_41720_().getRegistryName().toString());
            if (minecraft.f_91068_ != null) {
                minecraft.f_91068_.m_90911_(itextcomponent.getString());
            }
            if (data != null) {
                itextcomponent.m_130946_(NbtUtils.m_178057_((Tag)data));
            }
            itextcomponent.m_130938_(arg_0 -> TooltipEvents.lambda$debugTooltip$0((MutableComponent)itextcomponent, arg_0));
            minecraft.f_91074_.m_5661_((Component)itextcomponent, false);
            boolean bl = minecraft.f_91066_.f_92063_ = !minecraft.f_91066_.f_92063_;
        }
        if (KiwiClientConfig.nbtTooltip && Screen.m_96638_() && stack.m_41782_()) {
            TooltipEvents.trySendTipMsg(minecraft);
            tooltip.removeIf(c -> c.getClass() == TranslatableComponent.class && "item.nbt_tags".equals(((TranslatableComponent)c).m_131328_()));
            if (lastNBT != stack.m_41783_()) {
                switch (KiwiClientConfig.debugTooltipNBTFormatter) {
                    case "kiwi": {
                        formatter = tag -> {
                            ChatFormatting[] colors = new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.AQUA};
                            String s = tag.toString();
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            boolean quoted = false;
                            Iterator iterator = s.chars().boxed().collect(Collectors.toList()).iterator();
                            while (iterator.hasNext()) {
                                int ch = (Integer)iterator.next();
                                boolean special = false;
                                if (quoted) {
                                    if (ch == 34) {
                                        quoted = false;
                                        sb.appendCodePoint(ch);
                                        sb.append(ChatFormatting.WHITE);
                                        continue;
                                    }
                                } else {
                                    if (ch == 58 || ch == 44) {
                                        sb.append(ChatFormatting.GRAY);
                                        sb.appendCodePoint(ch);
                                        sb.append(ChatFormatting.WHITE);
                                        continue;
                                    }
                                    if (ch == 34) {
                                        quoted = true;
                                        sb.append(ChatFormatting.GRAY);
                                    } else if (ch == 123 || ch == 91) {
                                        ++i;
                                        special = true;
                                    } else if (ch == 125 || ch == 93) {
                                        special = true;
                                    }
                                }
                                if (special) {
                                    int colotIndex = i % colors.length;
                                    sb.append(colors[colotIndex]);
                                }
                                sb.appendCodePoint(ch);
                                if (!special) continue;
                                sb.append(ChatFormatting.WHITE);
                                if (ch != 125 && ch != 93) continue;
                                --i;
                            }
                            return new TextComponent(sb.toString());
                        };
                        break;
                    }
                    case "vanilla": {
                        formatter = tag -> NbtUtils.m_178061_((Tag)stack.m_41783_());
                        break;
                    }
                    default: {
                        formatter = tag -> new TextComponent(tag.toString());
                    }
                }
                lastNBT = stack.m_41783_();
                lastFormatted = (Component)formatter.apply((Object)lastNBT);
            }
            tooltip.add(lastFormatted);
        } else if (KiwiClientConfig.tagsTooltip && !(tags = stack.m_204131_().map(TagKey::f_203868_).map(Object::toString).sorted().toList()).isEmpty()) {
            TooltipEvents.trySendTipMsg(minecraft);
            tags.forEach(id -> tooltip.add((Component)new TextComponent("#" + id).m_130940_(ChatFormatting.DARK_GRAY)));
        }
    }

    private static void trySendTipMsg(Minecraft mc) {
        if (firstSeenDebugTooltip && mc.f_91074_ != null) {
            firstSeenDebugTooltip = false;
            if (KiwiClientConfig.debugTooltipMsg) {
                MutableComponent clickHere = new TranslatableComponent("tip.kiwi.click_here").m_130938_($ -> $.m_131142_(disableClickEvent));
                mc.f_91074_.m_6352_((Component)new TranslatableComponent("tip.kiwi.debug_tooltip", new Object[]{clickHere.m_130940_(ChatFormatting.AQUA)}), Util.f_137441_);
                ConfigHandler cfg = KiwiConfigManager.getHandler(KiwiClientConfig.class);
                ForgeConfigSpec.ConfigValue<?> val = cfg.getValueByPath("debug.debugTooltipMsg");
                val.set((Object)false);
                cfg.refresh();
            }
        }
    }

    private static /* synthetic */ Style lambda$debugTooltip$0(MutableComponent itextcomponent, Style style) {
        return style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, itextcomponent.getString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.copy.click"))).m_131138_(itextcomponent.getString());
    }

    static {
        firstSeenDebugTooltip = true;
        disableClickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "disableClickEvent");
    }
}

