/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public interface IControllerBoundable {
    public static final String CONTROLLER_POS_TAG = "controllerPos";

    public void setControllerPos(BlockPos var1);

    public Optional<BlockPos> getControllerPos();

    public void removeControllerPos();

    public BlockPos getStorageBlockPos();

    public Level getStorageBlockLevel();

    public boolean canConnectStorages();

    default public void runOnController(Level level, Consumer<ControllerBlockEntityBase> toRun) {
        this.getControllerPos().flatMap(pos -> WorldHelper.getLoadedBlockEntity(level, pos, ControllerBlockEntityBase.class)).ifPresent(toRun);
    }

    default public void saveControllerPos(CompoundTag tag) {
        this.getControllerPos().ifPresent(p -> tag.m_128356_(CONTROLLER_POS_TAG, p.m_121878_()));
    }

    default public void loadControllerPos(CompoundTag tag) {
        NBTHelper.getLong(tag, CONTROLLER_POS_TAG).ifPresent(value -> {
            BlockPos controllerPos = BlockPos.m_122022_((long)value);
            this.setControllerPos(controllerPos);
        });
    }
}

