/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;

public class StorageInventorySlot
extends SlotItemHandler {
    private final boolean isClientSide;
    private final IStorageWrapper storageWrapper;
    private final InventoryHandler inventoryHandler;
    private final int slotIndex;

    public StorageInventorySlot(boolean isClientSide, IStorageWrapper storageWrapper, InventoryHandler inventoryHandler, int slotIndex) {
        super((IItemHandler)inventoryHandler, slotIndex, 0, 0);
        this.isClientSide = isClientSide;
        this.storageWrapper = storageWrapper;
        this.inventoryHandler = inventoryHandler;
        this.slotIndex = slotIndex;
    }

    public void m_6654_() {
        super.m_6654_();
        this.storageWrapper.getInventoryHandler().onContentsChanged(this.slotIndex);
        this.processSlotChangeResponse(this.slotIndex, (IItemHandler)this.storageWrapper.getInventoryHandler(), this.storageWrapper);
    }

    private void processSlotChangeResponse(int slot, IItemHandler handler, IStorageWrapper storageWrapper) {
        if (!this.isClientSide) {
            storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(ISlotChangeResponseUpgrade.class).forEach(u -> u.onSlotChange(handler, slot));
        }
    }

    public int m_5866_(ItemStack stack) {
        return this.inventoryHandler.getStackLimit(this.slotIndex, stack);
    }

    public ItemStack m_150656_(ItemStack stack, int maxCount) {
        if (!stack.m_41619_() && this.m_5857_(stack)) {
            ItemStack itemstack = this.m_7993_();
            int i = Math.min(Math.min(maxCount, stack.m_41613_()), this.m_5866_(stack) - itemstack.m_41613_());
            if (itemstack.m_41619_()) {
                this.m_5852_(stack.m_41620_(i));
            } else if (ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack)) {
                stack.m_41774_(i);
                ItemStack copy = itemstack.m_41777_();
                copy.m_41769_(i);
                this.m_5852_(copy);
            }
            return stack;
        }
        return stack;
    }
}

