/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public abstract class ClientStorageContentsTooltip
implements ClientTooltipComponent {
    private static final int REFRESH_INTERVAL = 20;
    private static final String STORAGE_ITEM = "storage";
    protected static long lastRequestTime = 0L;
    @Nullable
    private static UUID storageUuid = null;
    private static List<IUpgradeWrapper> upgrades = new ArrayList<IUpgradeWrapper>();
    private static List<ItemStack> sortedContents = new ArrayList<ItemStack>();
    private static final List<Component> tooltipLines = new ArrayList<Component>();
    private static int height = 0;
    private static int width = 0;
    private static boolean shouldRefreshContents = true;
    private static final TextureBlitData UPGRADE_ON = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(4, 128), Dimension.RECTANGLE_4_10);
    private static final TextureBlitData UPGRADE_OFF = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(0, 128), Dimension.RECTANGLE_4_10);
    private static final int MAX_STACKS_ON_LINE = 9;
    private static final int DEFAULT_STACK_WIDTH = 18;
    private static final int COUNT_PADDING = 2;

    public static void refreshContents() {
        shouldRefreshContents = true;
    }

    private void initContents(LocalPlayer player, IStorageWrapper wrapper) {
        UUID newUuid = wrapper.getContentsUuid().orElse(null);
        if (storageUuid == null && newUuid != null || storageUuid != null && !storageUuid.equals(newUuid)) {
            this.setLastRequestTime(0L);
            storageUuid = newUuid;
            this.setShouldRefreshContents(true);
        }
        if (storageUuid != null) {
            this.requestContents(player, wrapper);
        }
        this.refreshContents(wrapper);
    }

    protected void setLastRequestTime(long lastRequestTime) {
        ClientStorageContentsTooltip.lastRequestTime = lastRequestTime;
    }

    protected long getLastRequestTime() {
        return lastRequestTime;
    }

    private void requestContents(LocalPlayer player, IStorageWrapper wrapper) {
        if (this.getLastRequestTime() + 20L < player.f_19853_.m_46467_()) {
            this.setLastRequestTime(player.f_19853_.m_46467_());
            wrapper.getContentsUuid().ifPresent(this::sendInventorySyncRequest);
        }
    }

    protected abstract void sendInventorySyncRequest(UUID var1);

    private void refreshContents(IStorageWrapper wrapper) {
        if (this.shouldRefreshContents()) {
            this.setShouldRefreshContents(false);
            sortedContents.clear();
            upgrades.clear();
            tooltipLines.clear();
            if (storageUuid != null) {
                wrapper.onContentsNbtUpdated();
                sortedContents = InventoryHelper.getCompactedStacksSortedByCount((IItemHandler)wrapper.getInventoryHandler());
                upgrades = new ArrayList<IUpgradeWrapper>(wrapper.getUpgradeHandler().getSlotWrappers().values());
                this.addMultiplierTooltip(wrapper);
                this.addFluidTooltip(wrapper);
                this.addEnergyTooltip(wrapper);
            }
            if (upgrades.isEmpty() && sortedContents.isEmpty()) {
                tooltipLines.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".empty").m_130940_(ChatFormatting.YELLOW));
            }
            this.calculateHeight();
            this.calculateWidth();
        }
    }

    protected void setShouldRefreshContents(boolean shouldRefreshContents) {
        ClientStorageContentsTooltip.shouldRefreshContents = shouldRefreshContents;
    }

    protected boolean shouldRefreshContents() {
        return shouldRefreshContents;
    }

    private void calculateWidth() {
        int upgradesWidth = this.calculateUpgradesWidth();
        int contentsWidth = this.calculateContentsWidth();
        int tooltipContentsWidth = this.calculateTooltipLinesWidth();
        int stacksWidth = Math.max(upgradesWidth, contentsWidth);
        width = Math.max(stacksWidth, tooltipContentsWidth);
    }

    private int calculateTooltipLinesWidth() {
        return tooltipLines.stream().map(this::getTooltipWidth).max(Comparator.naturalOrder()).orElse(0);
    }

    private int calculateUpgradesWidth() {
        int upgradesWidth = 0;
        for (IUpgradeWrapper upgradeWrapper : upgrades) {
            upgradesWidth += (upgradeWrapper.canBeDisabled() ? 4 : 0) + 18;
        }
        return upgradesWidth;
    }

    private int calculateContentsWidth() {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int contentsWidth = 0;
        for (int i = 0; i < sortedContents.size() && i < 9; ++i) {
            int countWidth = this.getStackCountWidth(fontRenderer, sortedContents.get(i));
            contentsWidth += Math.max(countWidth, 18);
        }
        return contentsWidth;
    }

    private int getStackCountWidth(Font fontRenderer, ItemStack stack) {
        return fontRenderer.m_92895_(CountAbbreviator.abbreviate(stack.m_41613_())) + 2;
    }

    private int getTooltipWidth(Component component) {
        return Minecraft.m_91087_().f_91062_.m_92724_(component.m_7532_());
    }

    private void addMultiplierTooltip(IStorageWrapper wrapper) {
        double multiplier = wrapper.getInventoryHandler().getStackSizeMultiplier();
        if (multiplier > 1.0) {
            DecimalFormat df = new DecimalFormat("0.###");
            tooltipLines.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".stack_multiplier", new Object[]{new TextComponent(df.format(multiplier)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
        }
    }

    private void addEnergyTooltip(IStorageWrapper wrapper) {
        wrapper.getEnergyStorage().ifPresent(energyStorage -> tooltipLines.add((Component)new TranslatableComponent(this.getEnergyTooltipTranslation(), new Object[]{new TextComponent(CountAbbreviator.abbreviate(energyStorage.getEnergyStored())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)));
    }

    protected String getEnergyTooltipTranslation() {
        return TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".energy";
    }

    private void addFluidTooltip(IStorageWrapper wrapper) {
        wrapper.getFluidHandler().ifPresent(fluidHandler -> {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluid = fluidHandler.getFluidInTank(tank);
                if (fluid.isEmpty()) {
                    tooltipLines.add((Component)new TranslatableComponent(this.getEmptyFluidTooltipTranslation()).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                tooltipLines.add((Component)new TranslatableComponent(this.getFluidTooltipTranslation(), new Object[]{new TextComponent(CountAbbreviator.abbreviate(fluid.getAmount())).m_130940_(ChatFormatting.WHITE), new TranslatableComponent(fluid.getTranslationKey()).m_130940_(ChatFormatting.BLUE)}));
            }
        });
    }

    protected String getFluidTooltipTranslation() {
        return TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".fluid";
    }

    protected String getEmptyFluidTooltipTranslation() {
        return TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".fluid_empty";
    }

    private void calculateHeight() {
        int upgradesHeight = upgrades.isEmpty() ? 0 : 32;
        int inventoryHeight = sortedContents.isEmpty() ? 0 : 12 + (1 + (sortedContents.size() - 1) / 9) * 20;
        int totalHeight = upgradesHeight + inventoryHeight + tooltipLines.size() * 10;
        height = totalHeight > 0 ? totalHeight : 12;
    }

    public int m_142069_(Font font) {
        return width;
    }

    public int m_142103_() {
        return height;
    }

    protected void renderTooltip(IStorageWrapper wrapper, Font font, int leftX, int topY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        this.initContents(player, wrapper);
        this.renderComponent(font, leftX, topY, poseStack, itemRenderer, blitOffset, minecraft);
    }

    private void renderComponent(Font font, int leftX, int topY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset, Minecraft minecraft) {
        for (Component tooltipLine : tooltipLines) {
            topY = this.renderTooltipLine(poseStack, leftX, topY, font, blitOffset, tooltipLine);
        }
        this.renderContentsTooltip(minecraft, font, leftX, topY, poseStack, itemRenderer, blitOffset);
    }

    private void renderContentsTooltip(Minecraft minecraft, Font font, int leftX, int topY, PoseStack poseStack, ItemRenderer itemRenderer, double blitOffset) {
        float currentBlitoffset = itemRenderer.f_115093_;
        itemRenderer.f_115093_ = currentBlitoffset + 200.0f;
        if (!upgrades.isEmpty()) {
            topY = this.renderTooltipLine(poseStack, leftX, topY, font, blitOffset, (Component)new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".upgrades").m_130940_(ChatFormatting.YELLOW));
            topY = this.renderUpgrades(poseStack, leftX, topY, itemRenderer);
        }
        if (!sortedContents.isEmpty()) {
            topY = this.renderTooltipLine(poseStack, leftX, topY, font, blitOffset, (Component)new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip(STORAGE_ITEM) + ".inventory").m_130940_(ChatFormatting.YELLOW));
            this.renderContents(minecraft, leftX, topY, itemRenderer, font);
        }
        itemRenderer.f_115093_ = currentBlitoffset;
    }

    private int renderTooltipLine(PoseStack poseStack, int leftX, int topY, Font font, double blitOffset, Component tooltip) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, blitOffset + 200.0);
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92841_(tooltip, (float)leftX, (float)topY, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
        renderTypeBuffer.m_109911_();
        poseStack.m_85837_(0.0, 0.0, -(blitOffset + 200.0));
        poseStack.m_85849_();
        return topY + 10;
    }

    private int renderUpgrades(PoseStack matrixStack, int leftX, int topY, ItemRenderer itemRenderer) {
        int x = leftX;
        for (IUpgradeWrapper upgradeWrapper : upgrades) {
            if (upgradeWrapper.canBeDisabled()) {
                RenderSystem.m_69465_();
                GuiHelper.blit(matrixStack, x, topY + 3, upgradeWrapper.isEnabled() ? UPGRADE_ON : UPGRADE_OFF);
                x += 4;
            }
            itemRenderer.m_115203_(upgradeWrapper.getUpgradeStack(), x, topY);
            x += 18;
        }
        return topY += 20;
    }

    private void renderContents(Minecraft minecraft, int leftX, int topY, ItemRenderer itemRenderer, Font font) {
        int x = leftX;
        for (int i = 0; i < sortedContents.size(); ++i) {
            int y = topY + i / 9 * 20;
            if (i % 9 == 0) {
                x = leftX;
            }
            ItemStack stack = sortedContents.get(i);
            int stackWidth = Math.max(this.getStackCountWidth(minecraft.f_91062_, stack), 18);
            int xOffset = stackWidth - 18;
            itemRenderer.m_115203_(stack, x + xOffset, y);
            itemRenderer.m_115174_(font, stack, x + xOffset, y, CountAbbreviator.abbreviate(stack.m_41613_()));
            x += stackWidth;
        }
    }
}

