/*
 * Decompiled with CFR 0.152.
 */
package com.kesselot.iobtracker.item;

import com.kesselot.iobtracker.ModItems;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class TrackerProperties
implements ClampedItemPropertyFunction {
    private final Wobble wobble = new Wobble();
    private final Wobble wobbleRandom = new Wobble();

    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)ModItems.TRACKER.get()), (ResourceLocation)new ResourceLocation("iobtrack", "angle"), (ItemPropertyFunction)new TrackerProperties()));
    }

    public float m_142187_(ItemStack p_174672_, @Nullable ClientLevel p_174673_, @Nullable LivingEntity p_174674_, int p_174675_) {
        LivingEntity entity;
        Object object = entity = p_174674_ != null ? p_174674_ : p_174672_.m_41609_();
        if (entity == null) {
            return 0.0f;
        }
        if (p_174673_ == null && entity.f_19853_ instanceof ClientLevel) {
            p_174673_ = (ClientLevel)entity.f_19853_;
        }
        BlockPos blockpos = TrackerProperties.position(p_174672_, p_174673_, p_174674_, p_174675_);
        long i = p_174673_.m_46467_();
        if (blockpos != null && !(entity.m_20182_().m_82531_((double)blockpos.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)blockpos.m_123343_() + 0.5) < (double)1.0E-5f)) {
            double d3;
            boolean flag = p_174674_ instanceof Player && ((Player)p_174674_).m_7578_();
            double d1 = 0.0;
            if (flag) {
                d1 = p_174674_.m_146908_();
            } else if (entity instanceof ItemEntity) {
                d1 = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
            } else if (p_174674_ != null) {
                d1 = p_174674_.f_20883_;
            }
            d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
            double d2 = TrackerProperties.getAngleTo(Vec3.m_82512_((Vec3i)blockpos), (Entity)entity) / 6.2831854820251465;
            if (flag) {
                if (this.wobble.shouldUpdate(i)) {
                    this.wobble.update(i, 0.5 - (d1 - 0.25));
                }
                d3 = d2 + this.wobble.rotation;
            } else {
                d3 = 0.5 - (d1 - 0.25 - d2);
            }
            return Mth.m_14091_((float)((float)d3), (float)1.0f);
        }
        if (this.wobbleRandom.shouldUpdate(i)) {
            this.wobbleRandom.update(i, Math.random());
        }
        double d0 = this.wobbleRandom.rotation + (double)((float)TrackerProperties.hash(p_174675_) / 2.1474836E9f);
        return Mth.m_14091_((float)((float)d0), (float)1.0f);
    }

    public static BlockPos position(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (level == null || entity == null) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("TrackedDragonClass", 8)) {
            return null;
        }
        int x = tag.m_128451_("TrackedX");
        int y = tag.m_128451_("TrackedY");
        int z = tag.m_128451_("TrackedZ");
        return new BlockPos(x, y, z);
    }

    public static double getAngleTo(Vec3 p_117919_, Entity p_117920_) {
        return Math.atan2(p_117919_.m_7094_() - p_117920_.m_20189_(), p_117919_.m_7096_() - p_117920_.m_20185_());
    }

    public static int hash(int p_174670_) {
        return p_174670_ * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Wobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        Wobble() {
        }

        boolean shouldUpdate(long pGameTime) {
            return this.lastUpdateTick != pGameTime;
        }

        void update(long pGameTime, double pWobbleAmount) {
            this.lastUpdateTick = pGameTime;
            double d0 = pWobbleAmount - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.03;
            this.deltaRotation *= 0.4;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

