/*
 * Decompiled with CFR 0.152.
 */
package com.kesselot.iobtracker;

import com.GACMD.isleofberk.entity.dragons.deadlynadder.DeadlyNadder;
import com.GACMD.isleofberk.entity.dragons.gronckle.Gronckle;
import com.GACMD.isleofberk.entity.dragons.lightfury.LightFury;
import com.GACMD.isleofberk.entity.dragons.montrous_nightmare.MonstrousNightmare;
import com.GACMD.isleofberk.entity.dragons.nightfury.NightFury;
import com.GACMD.isleofberk.entity.dragons.nightlight.NightLight;
import com.GACMD.isleofberk.entity.dragons.skrill.Skrill;
import com.GACMD.isleofberk.entity.dragons.speedstinger.SpeedStinger;
import com.GACMD.isleofberk.entity.dragons.speedstingerleader.SpeedStingerLeader;
import com.GACMD.isleofberk.entity.dragons.terrible_terror.TerribleTerror;
import com.GACMD.isleofberk.entity.dragons.triple_stryke.TripleStryke;
import com.GACMD.isleofberk.entity.dragons.zippleback.ZippleBack;
import com.kesselot.iobtracker.ModItems;
import com.kesselot.iobtracker.NetworkHandler;
import com.kesselot.iobtracker.item.TrackerProperties;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="iobtrack")
public class IOBTracker {
    private static final Logger LOGGER = LogUtils.getLogger();

    public IOBTracker() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::clientSetup);
        ModItems.ITEMS.register(modBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        TrackerProperties.clientSetup(event);
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    public static List<LivingEntity> getDragonsNearPlayer(ServerPlayer player) {
        return IOBTracker.getDragonsNearPosition(player.m_183503_(), player.m_142538_());
    }

    public static List<LivingEntity> getDragonsNearPosition(ServerLevel lvl, BlockPos pos) {
        ArrayList<LivingEntity> ret = new ArrayList<LivingEntity>();
        double maxDistanceSq = 25600.0;
        for (Entity e : lvl.m_8583_()) {
            double dz;
            double dx;
            LivingEntity living;
            if (!(e instanceof LivingEntity) || !IOBTracker.isIOBDragon((Entity)(living = (LivingEntity)e)) || !living.m_6084_() || !((dx = living.m_20185_() - (double)pos.m_123341_()) * dx + (dz = living.m_20189_() - (double)pos.m_123343_()) * dz <= maxDistanceSq)) continue;
            ret.add(living);
        }
        return ret;
    }

    public static boolean isIOBDragon(Entity entity) {
        return entity instanceof NightFury || entity instanceof LightFury || entity instanceof NightLight || entity instanceof TripleStryke || entity instanceof Skrill || entity instanceof DeadlyNadder || entity instanceof Gronckle || entity instanceof MonstrousNightmare || entity instanceof ZippleBack || entity instanceof TerribleTerror || entity instanceof SpeedStinger || entity instanceof SpeedStingerLeader;
    }
}

