/*
 * Decompiled with CFR 0.152.
 */
package com.kesselot.iobtracker;

import com.kesselot.iobtracker.DragonSelectPacket;
import com.kesselot.iobtracker.NetworkHandler;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class DragonTrackerScreen
extends Screen {
    private final List<UUID> dragonUUIDs;
    private final List<String> dragonNames;

    public DragonTrackerScreen(List<UUID> uuids, List<String> names) {
        super((Component)new TranslatableComponent("screen.iobtrack.tracker"));
        this.dragonUUIDs = uuids;
        this.dragonNames = names;
    }

    protected void m_7856_() {
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacingX = 10;
        int spacingY = 25;
        int cols = 3;
        int rows = 2;
        int totalSlots = cols * rows;
        int totalWidth = (buttonWidth + spacingX) * cols - spacingX;
        int startX = (this.f_96543_ - totalWidth) / 2;
        int startY = 40;
        int added = 0;
        for (int i = 0; i < this.dragonNames.size() && added < totalSlots; ++added, ++i) {
            String name = this.dragonNames.get(i);
            UUID uuid = this.dragonUUIDs.get(i);
            int col = added % cols;
            int row = added / cols;
            int x = startX + col * (buttonWidth + spacingX);
            int y = startY + row * (buttonHeight + spacingY);
            Button button = new Button(x, y, buttonWidth, buttonHeight, (Component)new TextComponent(name), btn -> {
                System.out.println("[IOBTRACKER] BUTTON PRESSED! Selecting: " + name + " (UUID: " + String.valueOf(uuid) + ")");
                this.onSelect(uuid);
            });
            this.m_142416_((GuiEventListener)button);
        }
        if (this.dragonNames.isEmpty()) {
            Button closeBtn = new Button(this.f_96543_ / 2 - 75, 40, 150, 20, (Component)new TranslatableComponent("gui.iobtrack.no_dragons"), btn -> this.m_7379_());
            this.m_142416_((GuiEventListener)closeBtn);
        }
        Button doneBtn = new Button(this.f_96543_ / 2 - 40, this.f_96544_ - 30, 80, 20, (Component)new TranslatableComponent("gui.done"), btn -> {
            System.out.println("[IOBTRACKER] Done button pressed");
            this.m_7379_();
        });
        this.m_142416_((GuiEventListener)doneBtn);
    }

    private void onSelect(UUID uuid) {
        NetworkHandler.INSTANCE.sendToServer((Object)new DragonSelectPacket(uuid));
        this.m_7379_();
    }

    public void m_7379_() {
        super.m_7379_();
    }
}

