/*
 * Decompiled with CFR 0.152.
 */
package com.kesselot.iobtracker;

import com.GACMD.isleofberk.registery.ModItems;
import com.kesselot.iobtracker.item.DragonTrackerItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DragonSelectPacket {
    private final UUID dragonUUID;

    public DragonSelectPacket(UUID uuid) {
        this.dragonUUID = uuid;
    }

    public DragonSelectPacket(FriendlyByteBuf buf) {
        this.dragonUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.dragonUUID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            LivingEntity target = null;
            ServerLevel serverLevel = (ServerLevel)player.f_19853_;
            for (Entity e : serverLevel.m_8583_()) {
                if (!e.m_142081_().equals(this.dragonUUID) || !(e instanceof LivingEntity)) continue;
                target = (LivingEntity)e;
                break;
            }
            if (target != null) {
                ItemStack offhand;
                boolean consumed = false;
                Item gronckleIron = (Item)ModItems.GRONCKLE_IRON.get();
                Inventory inv = player.m_150109_();
                for (int i = 0; i < inv.f_35974_.size(); ++i) {
                    ItemStack stack = (ItemStack)inv.f_35974_.get(i);
                    if (stack.m_41619_() || stack.m_41720_() != gronckleIron) continue;
                    if (stack.m_41613_() > 1) {
                        stack.m_41774_(1);
                    } else {
                        inv.m_6836_(i, ItemStack.f_41583_);
                    }
                    consumed = true;
                    break;
                }
                if (!consumed && !(offhand = (ItemStack)inv.f_35976_.get(0)).m_41619_() && offhand.m_41720_() == gronckleIron) {
                    if (offhand.m_41613_() > 1) {
                        offhand.m_41774_(1);
                    } else {
                        inv.f_35976_.set(0, (Object)ItemStack.f_41583_);
                    }
                    consumed = true;
                }
                if (consumed) {
                    ItemStack tracker = player.m_21205_();
                    if (tracker.m_41720_() instanceof DragonTrackerItem) {
                        CompoundTag tag = tracker.m_41784_();
                        tag.m_128365_("TrackedDragonUUID", (Tag)NbtUtils.m_129226_((UUID)target.m_142081_()));
                        tag.m_128359_("TrackedDragonClass", target.getClass().getName());
                        ((Slot)player.f_36096_.f_38839_.get(36 + player.m_150109_().f_35977_)).m_5852_(tracker);
                    }
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123783_, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 20, 0.5, 0.5, 0.5, 0.1);
                    double dx = target.m_20185_() - player.m_20185_();
                    double dz = target.m_20189_() - player.m_20189_();
                    int distance = (int)Math.sqrt(dx * dx + dz * dz);
                    player.m_6352_((Component)new TranslatableComponent("item.iobtrack.tracker.found", new Object[]{target.m_6095_().m_20676_(), distance, target.m_142538_().m_123341_(), target.m_142538_().m_123342_(), target.m_142538_().m_123343_()}).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
                } else {
                    player.m_6352_((Component)new TranslatableComponent("item.iobtrack.tracker.no_gronckle_iron").m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
            }
        });
        return true;
    }
}

