/*
 * Decompiled with CFR 0.152.
 */
package com.kesselot.iobtracker;

import com.kesselot.iobtracker.DragonTrackerScreen;
import com.kesselot.iobtracker.IOBTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class DragonListPacket {
    private final List<UUID> uuids;
    private final List<String> names;

    public DragonListPacket(ServerPlayer player) {
        this.uuids = new ArrayList<UUID>();
        this.names = new ArrayList<String>();
        List<LivingEntity> dragons = IOBTracker.getDragonsNearPlayer(player);
        if (dragons.isEmpty()) {
            player.m_6352_((Component)new TranslatableComponent("item.iobtrack.tracker.none"), Util.f_137441_);
            return;
        }
        Random random = new Random(player.m_183503_().m_46467_());
        Collections.shuffle(dragons, random);
        int count = Math.min(dragons.size(), 6);
        for (int i = 0; i < count; ++i) {
            String baseName;
            LivingEntity e = dragons.get(i);
            String displayName = baseName = e.m_6095_().m_20676_().getString();
            this.uuids.add(e.m_142081_());
            this.names.add(displayName);
        }
    }

    public DragonListPacket(FriendlyByteBuf buf) {
        int count = buf.readInt();
        this.uuids = new ArrayList<UUID>();
        this.names = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            this.uuids.add(buf.m_130259_());
            this.names.add(buf.m_130136_(Short.MAX_VALUE));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.uuids.size());
        for (int i = 0; i < this.uuids.size(); ++i) {
            buf.m_130077_(this.uuids.get(i));
            buf.m_130072_(this.names.get(i), Short.MAX_VALUE);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                this.openScreen();
            }
        });
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new DragonTrackerScreen(this.uuids, this.names));
    }
}

