/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.core.integration.jei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import xyz.apex.forge.apexcore.registrate.entry.ItemEntry;
import xyz.apex.forge.apexcore.registrate.entry.ItemLikeEntry;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllItems;
import xyz.apex.forge.fantasyfurniture.client.screen.FurnitureStationMenuScreen;
import xyz.apex.forge.fantasyfurniture.common.block.FurnitureStationBlock;
import xyz.apex.forge.fantasyfurniture.common.menu.FurnitureStationMenu;
import xyz.apex.forge.fantasyfurniture.core.FurnitureStation;
import xyz.apex.forge.fantasyfurniture.core.integration.jei.FurnitureStationRecipeCategory;
import xyz.apex.forge.fantasyfurniture.core.integration.jei.FurnitureStationRecipes;

@mezz.jei.api.JeiPlugin
public final class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("fantasyfurniture", "jei_integration");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jei = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new FurnitureStationRecipeCategory(jei)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IJeiHelpers jei = registration.getJeiHelpers();
        List<ItemStack> results = FurnitureStation.buildResultsList();
        List<FurnitureStationRecipes> recipes = Collections.singletonList(new FurnitureStationRecipes(results, jei));
        registration.addRecipes(FurnitureStationRecipes.RECIPE_TYPE, recipes);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(FurnitureStationMenu.class, FurnitureStationRecipes.RECIPE_TYPE, 0, 3, 4, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        Font font = Minecraft.m_91087_().f_91062_;
        int imageWidth = 176;
        int titleWidth = font.m_92852_((FormattedText)((FurnitureStationBlock)AllBlocks.FURNITURE_STATION.get()).m_49954_());
        int titleLabelX = (imageWidth - titleWidth) / 2;
        int titleLabelY = 6;
        Objects.requireNonNull(font);
        registration.addRecipeClickArea(FurnitureStationMenuScreen.class, titleLabelX, titleLabelY, titleWidth, 9, new RecipeType[]{FurnitureStationRecipes.RECIPE_TYPE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(AllBlocks.FURNITURE_STATION.asStack(), new RecipeType[]{FurnitureStationRecipes.RECIPE_TYPE});
        Arrays.stream(new ItemEntry[]{AllItems.NORDIC_OVEN, AllItems.DUNMER_OVEN, AllItems.VENTHYR_OVEN, AllItems.BONE_SKELETON_OVEN, AllItems.BONE_WITHER_OVEN, AllItems.ROYAL_OVEN, AllItems.NECROLORD_OVEN}).map(ItemLikeEntry::asStack).forEach(stack -> registration.addRecipeCatalyst(stack, new RecipeType[]{RecipeTypes.SMOKING}));
    }
}

