/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class ChandelierBlock
extends BaseBlock {
    public ChandelierBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)WATERLOGGED);
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (!ChandelierBlock.isWaterLogged((BlockState)blockState)) {
            this.spawnLightParticles(blockState, level, pos, rng);
        }
    }

    protected void spawnLightParticles(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (AllBlocks.NORDIC_CHANDELIER.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.65;
            double z = (double)pos.m_123343_() + 0.5;
            this.onLightParticle(level, pos, blockState, x + 0.25, y, z + 0.25, rng);
            this.onLightParticle(level, pos, blockState, x - 0.25, y, z + 0.25, rng);
            this.onLightParticle(level, pos, blockState, x + 0.25, y, z - 0.25, rng);
            this.onLightParticle(level, pos, blockState, x - 0.25, y, z - 0.25, rng);
        } else if (AllBlocks.DUNMER_CHANDELIER.isIn(blockState) || AllBlocks.ROYAL_CHANDELIER.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.875;
            double z = (double)pos.m_123343_() + 0.5;
            this.onLightParticle(level, pos, blockState, x + 0.275, y, z + 0.275, rng);
            this.onLightParticle(level, pos, blockState, x + 0.275, y, z - 0.275, rng);
            this.onLightParticle(level, pos, blockState, x - 0.275, y, z + 0.275, rng);
            this.onLightParticle(level, pos, blockState, x - 0.275, y, z - 0.275, rng);
        } else if (AllBlocks.VENTHYR_CHANDELIER.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.2;
            double y = (double)pos.m_123342_() + 0.55;
            double z = (double)pos.m_123343_() + 0.2;
            this.onLightParticle(level, pos, blockState, x, y, z, rng);
            this.onLightParticle(level, pos, blockState, x + 0.6, y, z, rng);
            this.onLightParticle(level, pos, blockState, x + 0.6, y, z + 0.6, rng);
            this.onLightParticle(level, pos, blockState, x, y, z + 0.6, rng);
            this.onLightParticle(level, pos, blockState, x + 0.1, y + 0.2, z + 0.1, rng);
            this.onLightParticle(level, pos, blockState, x + 0.1 + 0.4, y + 0.2, z + 0.1, rng);
            this.onLightParticle(level, pos, blockState, x + 0.1 + 0.4, y + 0.2, z + 0.1 + 0.4, rng);
            this.onLightParticle(level, pos, blockState, x + 0.1, y + 0.2, z + 0.1 + 0.4, rng);
        } else if (AllBlocks.BONE_SKELETON_CHANDELIER.isIn(blockState) || AllBlocks.BONE_WITHER_CHANDELIER.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.8;
            double z = (double)pos.m_123343_() + 0.5;
            this.onLightParticle(level, pos, blockState, x + 0.4, y, z, rng);
            this.onLightParticle(level, pos, blockState, x - 0.4, y, z, rng);
            this.onLightParticle(level, pos, blockState, x, y, z + 0.4, rng);
            this.onLightParticle(level, pos, blockState, x, y, z - 0.4, rng);
        } else if (AllBlocks.NECROLORD_CHANDELIER.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.65;
            double z = (double)pos.m_123343_() + 0.5;
            this.onLightParticle(level, pos, blockState, x, y, z, rng);
        }
    }

    protected void onLightParticle(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, Random rng) {
        SimpleParticleType flame = ParticleTypes.f_123744_;
        if (AllBlocks.BONE_WITHER_CHANDELIER.isIn(blockState)) {
            flame = ParticleTypes.f_123745_;
        } else if (AllBlocks.NECROLORD_CHANDELIER.isIn(blockState)) {
            flame = (SimpleParticleType)AllParticleTypes.NECROLORD_FLAME.get();
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pX, pY, pZ, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)flame, pX, pY, pZ, 0.0, 0.0, 0.0);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_CHANDELIER.isIn(blockState)) {
            return HitBoxes.NORDIC.chandelier(this, blockState);
        }
        if (AllBlocks.DUNMER_CHANDELIER.isIn(blockState)) {
            return HitBoxes.DUNMER.chandelier(this, blockState);
        }
        if (AllBlocks.VENTHYR_CHANDELIER.isIn(blockState)) {
            return HitBoxes.VENTHYR.chandelier(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_CHANDELIER.isIn(blockState) || AllBlocks.BONE_WITHER_CHANDELIER.isIn(blockState)) {
            return HitBoxes.BONE.chandelier(this, blockState);
        }
        if (AllBlocks.ROYAL_CHANDELIER.isIn(blockState)) {
            return HitBoxes.ROYAL.chandelier(this, blockState);
        }
        if (AllBlocks.NECROLORD_CHANDELIER.isIn(blockState)) {
            return HitBoxes.NECROLORD.chandelier(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static class Dyeable
    extends ChandelierBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MaterialColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
            MaterialColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

