/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.BaseMultiBlock;

public abstract class BedBlock
extends BaseMultiBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;

    public BedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)OCCUPIED);
    }

    @Nullable
    public Direction getFourWayFacing(BlockPlaceContext ctx) {
        return ctx.m_8125_();
    }

    protected abstract int getBedFootMultiBlockIndex(BlockState var1);

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockPos footPos = BedBlock.getBedFootPos(this, blockState, pos);
        BlockState footBlockState = blockState;
        if (!footPos.equals((Object)pos)) {
            footBlockState = level.m_8055_(footPos);
        }
        if (!footBlockState.m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!net.minecraft.world.level.block.BedBlock.m_49488_((Level)level)) {
            return this.onBadBedSetSpawn(level, footBlockState, footPos, player, hand);
        }
        if (((Boolean)footBlockState.m_61143_((Property)OCCUPIED)).booleanValue()) {
            return this.onBedOccupied(level, footBlockState, footPos, player, hand);
        }
        return this.onSleepInBed(level, footBlockState, footPos, player, hand);
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos pos, Entity entity, float dist) {
        super.m_142072_(level, blockState, pos, entity, dist * 0.5f);
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            BedBlock.bounceUp(entity);
        }
    }

    public boolean isBed(BlockState blockState, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return blockState.m_60713_((Block)this);
    }

    public void setBedOccupied(BlockState blockState, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        BlockPos footPos = BedBlock.getBedFootPos(this, blockState, pos);
        BlockState footBlockState = level.m_8055_(footPos);
        BlockPos headPos = footPos.m_142300_(BaseBlock.getFacing((BlockState)footBlockState));
        BlockState headBlockState = level.m_8055_(headPos);
        super.setBedOccupied(footBlockState, level, footPos, sleeper, occupied);
        super.setBedOccupied(headBlockState, level, headPos, sleeper, occupied);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter level, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public void onFixBedRotations(LivingEntity entity, PoseStack pose) {
    }

    protected InteractionResult onBadBedSetSpawn(Level level, BlockState blockState, BlockPos pos, Player player, InteractionHand hand) {
        level.m_7471_(pos, false);
        level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult onBedOccupied(Level level, BlockState blockState, BlockPos pos, Player player, InteractionHand hand) {
        if (!BedBlock.kickVillagerOutOfBed(level, pos)) {
            player.m_5661_(this.getOccupiedTranslation(), true);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult onSleepInBed(Level level, BlockState blockState, BlockPos pos, Player player, InteractionHand hand) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        BlockPos sleepPos = pos.m_142300_(facing);
        player.m_7720_(sleepPos).ifLeft(result -> {
            if (result != null) {
                player.m_5661_(result.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public String getOccupiedTranslationKey() {
        return "%s.occupied".formatted(this.m_7705_());
    }

    public Component getOccupiedTranslation() {
        return new TranslatableComponent(this.getOccupiedTranslationKey());
    }

    public static boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagersInBed = level.m_142425_((EntityTypeTest)EntityType.f_20492_, new AABB(pos), LivingEntity::m_5803_);
        if (villagersInBed.isEmpty()) {
            return false;
        }
        ((Villager)villagersInBed.get(0)).m_5796_();
        return true;
    }

    public static void bounceUp(Entity entity) {
        Vec3 delta = entity.m_20184_();
        if (delta.f_82480_ < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(delta.f_82479_, -delta.f_82480_ * (double)0.66f * d, delta.f_82481_);
        }
    }

    public static BlockPos getBedFootPos(BedBlock bed, BlockState blockState, BlockPos pos) {
        int footIndex = bed.getBedFootMultiBlockIndex(blockState);
        int currentIndex = bed.getMultiBlockIndex(blockState);
        if (currentIndex == footIndex) {
            return pos;
        }
        BlockPos origin = bed.getMultiBlockOriginPos(blockState, pos);
        BlockPos footLocalSpace = (BlockPos)bed.getMultiBlockLocalPositions().get(footIndex);
        return bed.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, footLocalSpace);
    }
}

