/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.decorations;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;

public final class CandleBlock
extends BaseBlock {
    public static final VoxelShape SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{CandleBlock.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)8.0, (double)3.0, (double)7.0), CandleBlock.m_49796_((double)9.0, (double)0.0, (double)5.0, (double)12.0, (double)6.0, (double)8.0), CandleBlock.m_49796_((double)8.0, (double)0.0, (double)10.0, (double)11.0, (double)8.0, (double)13.0), CandleBlock.m_49796_((double)4.0, (double)0.0, (double)9.0, (double)7.0, (double)5.0, (double)12.0)});
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal((VoxelShape)SHAPE, (Direction)Direction.NORTH);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public CandleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)LIT);
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult result, Projectile projectile) {
        super.m_5581_(level, blockState, result, projectile);
        if (!level.f_46443_ && projectile.m_6060_() && this.canBeLit(blockState)) {
            level.m_7731_(result.m_82425_(), CandleBlock.setLit(blockState, true), 11);
        }
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (!CandleBlock.isWaterLogged((BlockState)blockState) && CandleBlock.isLit(blockState)) {
            this.spawnLightParticles(blockState, level, pos, rng);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_150110_().f_35938_ && player.m_21120_(hand).m_41619_() && CandleBlock.isLit(blockState)) {
            CandleBlock.extinguish(player, blockState, (LevelAccessor)level, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction facing = CandleBlock.getFacing((BlockState)blockState);
        return SHAPER.get(facing);
    }

    private boolean canBeLit(BlockState blockState) {
        if (CandleBlock.isWaterLogged((BlockState)blockState)) {
            return false;
        }
        return !CandleBlock.isLit(blockState);
    }

    private void spawnLightParticles(BlockState blockState, Level level, BlockPos pos, Random rng) {
        Direction facing = CandleBlock.getFacing((BlockState)blockState);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        float smokeChance = rng.nextFloat();
        if (facing == Direction.NORTH) {
            this.onLightParticle(level, pos, blockState, (double)x + 0.4, (double)y + 0.313, (double)z + 0.35, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.65, (double)y + 0.5, (double)z + 0.4, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.375, (double)y + 0.45, (double)z + 0.65, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.6, (double)y + 0.65, (double)z + 0.725, smokeChance, rng);
        } else if (facing == Direction.EAST) {
            this.onLightParticle(level, pos, blockState, (double)x + 0.65, (double)y + 0.313, (double)z + 0.4, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.6, (double)y + 0.5, (double)z + 0.65, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.35, (double)y + 0.45, (double)z + 0.35, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.3, (double)y + 0.65, (double)z + 0.6, smokeChance, rng);
        } else if (facing == Direction.SOUTH) {
            this.onLightParticle(level, pos, blockState, (double)x + 0.6, (double)y + 0.313, (double)z + 0.65, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.35, (double)y + 0.5, (double)z + 0.6, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.4, (double)y + 0.65, (double)z + 0.3, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.65, (double)y + 0.45, (double)z + 0.3, smokeChance, rng);
        } else if (facing == Direction.WEST) {
            this.onLightParticle(level, pos, blockState, (double)x + 0.35, (double)y + 0.313, (double)z + 0.6, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.4, (double)y + 0.5, (double)z + 0.35, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.7, (double)y + 0.65, (double)z + 0.4, smokeChance, rng);
            this.onLightParticle(level, pos, blockState, (double)x + 0.65, (double)y + 0.45, (double)z + 0.65, smokeChance, rng);
        }
        if (smokeChance < 0.17f) {
            level.m_7785_((double)x, (double)y, (double)z, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + rng.nextFloat(), rng.nextFloat() * 0.7f + 0.3f, false);
        }
    }

    private void onLightParticle(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, float chance, Random rng) {
        SimpleParticleType flame = ParticleTypes.f_175834_;
        if (AllBlocks.BONE_CANDLES.isIn(blockState)) {
            flame = (SimpleParticleType)AllParticleTypes.SMALL_SOUL_FLAME.get();
        }
        level.m_7106_((ParticleOptions)flame, pX, pY, pZ, 0.0, 0.0, 0.0);
        if (chance < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pX, pY, pZ, 0.0, 0.0, 0.0);
        }
    }

    private void onExtinguishParticle(LevelAccessor level, BlockPos pos, BlockState blockState, Random rng) {
        Direction facing = CandleBlock.getFacing((BlockState)blockState);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (facing == Direction.NORTH) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.4, (double)y + 0.313, (double)z + 0.35, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.65, (double)y + 0.5, (double)z + 0.4, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.375, (double)y + 0.45, (double)z + 0.65, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.6, (double)y + 0.65, (double)z + 0.725, 0.0, 0.0, 0.0);
        } else if (facing == Direction.EAST) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.65, (double)y + 0.313, (double)z + 0.4, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.6, (double)y + 0.5, (double)z + 0.65, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.35, (double)y + 0.45, (double)z + 0.35, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.3, (double)y + 0.65, (double)z + 0.6, 0.0, 0.0, 0.0);
        } else if (facing == Direction.SOUTH) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.6, (double)y + 0.313, (double)z + 0.65, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.35, (double)y + 0.5, (double)z + 0.6, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.4, (double)y + 0.65, (double)z + 0.3, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.65, (double)y + 0.45, (double)z + 0.3, 0.0, 0.0, 0.0);
        } else if (facing == Direction.WEST) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.35, (double)y + 0.313, (double)z + 0.6, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.4, (double)y + 0.5, (double)z + 0.35, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.7, (double)y + 0.65, (double)z + 0.4, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x + 0.65, (double)y + 0.45, (double)z + 0.65, 0.0, 0.0, 0.0);
        }
    }

    public static BlockState setLit(BlockState blockState, boolean lit) {
        return CandleBlock.supportsLit(blockState) ? (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)) : blockState;
    }

    public static boolean isLit(BlockState blockState) {
        return blockState.m_61145_((Property)LIT).orElse(false);
    }

    public static boolean supportsLit(BlockState blockState) {
        return blockState.m_61138_((Property)LIT);
    }

    public static void extinguish(@Nullable Player player, BlockState blockState, LevelAccessor level, BlockPos pos) {
        Block block = blockState.m_60734_();
        if (block instanceof AbstractCandleBlock) {
            AbstractCandleBlock.m_151899_((Player)player, (BlockState)blockState, (LevelAccessor)level, (BlockPos)pos);
        } else if (block instanceof CandleBlock) {
            CandleBlock candle = (CandleBlock)block;
            level.m_7731_(pos, CandleBlock.setLit(blockState, false), 11);
            candle.onExtinguishParticle(level, pos, blockState, level.m_5822_());
            level.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        }
    }
}

