/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.client.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.client.screen.BaseMenuScreen;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.util.RegistryHelper;
import xyz.apex.forge.commonality.tags.ItemTags;
import xyz.apex.forge.fantasyfurniture.common.menu.FurnitureStationMenu;
import xyz.apex.forge.fantasyfurniture.core.FurnitureStation;
import xyz.apex.forge.fantasyfurniture.core.ModInitializer;
import xyz.apex.forge.fantasyfurniture.core.net.C2SSyncSelectedResultPacket;

public class FurnitureStationMenuScreen
extends BaseMenuScreen<FurnitureStationMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("fantasyfurniture", "textures/gui/container/furniture_station.png");
    private int clayIndex = 0;
    private int woodIndex = 0;
    private int stoneIndex = 0;
    private int cycleCounter = 0;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    @Nullable
    private EditBox searchBox;
    private boolean focusSearchBoxNextTick = false;
    private int currentSearchSyntaxColor = 0xFFFFFF;
    private boolean changeSearchSyntaxColor = true;
    private final Map<TagKey<Item>, List<ItemStack>> tagValues = Maps.newHashMap();
    private final Map<Item, List<TagKey<Item>>> itemTags = Maps.newHashMap();

    public FurnitureStationMenuScreen(FurnitureStationMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title, TEXTURE);
    }

    protected void m_7856_() {
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.f_96541_.f_91068_.m_90926_(true);
        super.m_7856_();
        this.f_97731_ = this.f_97727_ - 94;
        this.scrolling = false;
        this.startIndex = 0;
        this.scrollOffset = 0.0f;
        String text = this.searchBox == null ? "" : this.searchBox.m_94155_();
        int s = 73;
        int e = this.f_97726_ - 12;
        int w = e - s;
        int h = 16;
        int x = this.f_97735_ + s;
        Objects.requireNonNull(this.f_96547_);
        int y = this.f_97736_ + this.f_97729_ + 9 + 6;
        this.searchBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x, y, w, h, (Component)new TranslatableComponent("gui.recipebook.search_hint")));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(this.currentSearchSyntaxColor);
        this.searchBox.m_94144_(text);
        this.searchBox.m_94190_(true);
    }

    public void m_181908_() {
        if (this.searchBox != null) {
            Slot claySlot = ((FurnitureStationMenu)this.f_97732_).getClaySlot();
            Slot woodSlot = ((FurnitureStationMenu)this.f_97732_).getWoodSlot();
            Slot stoneSlot = ((FurnitureStationMenu)this.f_97732_).getStoneSlot();
            if (!(claySlot.m_6657_() && woodSlot.m_6657_() && stoneSlot.m_6657_())) {
                this.searchBox.f_93623_ = false;
                this.searchBox.m_94144_("");
                this.focusSearchBoxNextTick = false;
                this.searchBox.m_94178_(false);
                this.m_7522_(null);
            } else {
                this.searchBox.f_93623_ = true;
            }
            this.searchBox.m_94120_();
            if (this.focusSearchBoxNextTick) {
                if (!this.searchBox.m_93696_()) {
                    this.m_7522_((GuiEventListener)this.searchBox);
                    this.searchBox.m_94178_(true);
                }
                this.focusSearchBoxNextTick = false;
            }
        }
        this.updateSearchBoxSyntaxHighlighting();
        super.m_181908_();
    }

    public void m_7861_() {
        this.searchBox = null;
        this.f_96541_.f_91068_.m_90926_(false);
        super.m_7861_();
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        if (this.searchBox != null && this.searchBox.m_94213_() && !this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            MutableComponent mutableComponent = this.searchBox.m_6035_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            int n = this.searchBox.f_93620_ + 2;
            int n2 = this.searchBox.f_93621_;
            Objects.requireNonNull(this.f_96547_);
            FurnitureStationMenuScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)mutableComponent, (int)n, (int)(n2 + 9 / 2), (int)this.searchBox.getFGColor());
        }
        this.renderResults(pose, mouseX, mouseY);
        this.renderSlotBackgrounds(pose, mouseX, mouseY);
        if (this.searchBox != null && this.searchBox.m_94213_() && this.searchBox.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderComponentTooltip(pose, Arrays.asList(new TextComponent("'").m_7220_((Component)new TextComponent("@").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})).m_130946_("' -> Search by ").m_7220_((Component)new TextComponent("Mod ID").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})), new TextComponent("'").m_7220_((Component)new TextComponent("#").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})).m_130946_("' -> Search by ").m_7220_((Component)new TextComponent("ItemTag").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}))), mouseX, mouseY, this.f_96547_);
        }
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(pose, partialTicks, mouseX, mouseY);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = (int)(57.0f * this.scrollOffset);
        this.m_93228_(pose, i + 127, j + 45 + k, 194 + (this.scrollbarActive() ? 0 : 12), 0, 12, 15);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.scrolling = false;
        if (this.searchBox != null && this.searchBox.f_93623_ && this.searchBox.m_94213_()) {
            if (this.searchBox.m_6375_(mouseX, mouseY, mouseButton)) {
                this.changeSearchSyntaxColor = true;
                return true;
            }
            if (mouseButton == 1 && this.searchBox.m_5953_(mouseX, mouseY)) {
                this.changeSearchSyntaxColor = true;
                this.searchBox.m_94144_("");
                return true;
            }
        }
        if (this.clickedResult(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!((FurnitureStationMenu)this.f_97732_).getResults().isEmpty()) {
            int x = this.f_97735_ + 128;
            int y = this.f_97736_ + 46;
            int w = 12;
            int h = 71;
            if (mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + w) && mouseY < (double)(y + h)) {
                this.scrolling = true;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        List<ItemStack> results = ((FurnitureStationMenu)this.f_97732_).getResults();
        int size = results.size();
        if (this.scrolling && this.scrollbarActive()) {
            int i = this.f_97736_ + 44;
            int j = i + 73;
            int offscreenRows = (size + 6 - 1) / 4 - 4;
            this.scrollOffset = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5) * 6;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.scrollbarActive()) {
            List<ItemStack> results = ((FurnitureStationMenu)this.f_97732_).getResults();
            int size = results.size();
            int offscreenRows = (size + 6 - 1) / 4 - 4;
            this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5) * 6;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.f_93623_ && this.searchBox.m_94213_()) {
            if (this.searchBox.m_93696_()) {
                if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
                    this.changeSearchSyntaxColor = true;
                    return true;
                }
                if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
                    return false;
                }
                if (keyCode == 256) {
                    this.focusSearchBoxNextTick = false;
                    this.searchBox.m_94178_(false);
                    return true;
                }
            } else if (this.f_96541_.f_91066_.f_92098_.m_90832_(keyCode, scanCode)) {
                this.focusSearchBoxNextTick = true;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char typedChar, int modifiers) {
        if (this.searchBox != null && this.searchBox.f_93623_ && this.searchBox.m_93696_() && this.searchBox.m_94213_() && this.searchBox.m_5534_(typedChar, modifiers)) {
            this.changeSearchSyntaxColor = true;
            return true;
        }
        return super.m_5534_(typedChar, modifiers);
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (this.searchBox != null && !this.searchBox.f_93623_) {
            ArrayList kids = Lists.newArrayList((Iterable)super.m_6702_());
            kids.remove(this.searchBox);
            return kids;
        }
        return super.m_6702_();
    }

    private void updateSearchBoxSyntaxHighlighting() {
        if (this.searchBox == null || !this.changeSearchSyntaxColor) {
            return;
        }
        String value = this.searchBox.m_94155_();
        if (StringUtils.isBlank((CharSequence)value)) {
            int syntaxColor = 0xFFFFFF;
            this.searchBox.m_94202_(syntaxColor);
            this.currentSearchSyntaxColor = syntaxColor;
            return;
        }
        List<ItemStack> results = ((FurnitureStationMenu)this.f_97732_).getResults();
        if (!results.isEmpty()) {
            for (int j = this.startIndex; j < results.size(); ++j) {
                ItemStack resultItem = results.get(j);
                if (!this.isItemValid(resultItem)) continue;
                this.changeSearchSyntaxColor = false;
                int syntaxColor = DyeColor.GREEN.m_41071_();
                this.searchBox.m_94202_(syntaxColor);
                this.currentSearchSyntaxColor = syntaxColor;
                return;
            }
        }
        int syntaxColor = DyeColor.RED.m_41071_();
        this.searchBox.m_94202_(syntaxColor);
        this.currentSearchSyntaxColor = syntaxColor;
        this.changeSearchSyntaxColor = false;
    }

    private void renderSlotBackgrounds(PoseStack pose, int mouseX, int mouseY) {
        Slot claySlot = ((FurnitureStationMenu)this.f_97732_).getClaySlot();
        Slot woodSlot = ((FurnitureStationMenu)this.f_97732_).getWoodSlot();
        Slot stoneSlot = ((FurnitureStationMenu)this.f_97732_).getStoneSlot();
        this.clayIndex = this.renderSlotBackground(claySlot, FurnitureStation.CLAY, pose, mouseX, mouseY, this.clayIndex);
        this.woodIndex = this.renderSlotBackground(woodSlot, (TagKey<Item>)ItemTags.Vanilla.PLANKS, pose, mouseX, mouseY, this.woodIndex);
        this.stoneIndex = this.renderSlotBackground(stoneSlot, (TagKey<Item>)ItemTags.Vanilla.STONE_CRAFTING_MATERIALS, pose, mouseX, mouseY, this.stoneIndex);
        ++this.cycleCounter;
        if (this.cycleCounter > 125) {
            this.cycleCounter = 0;
        }
    }

    private int renderSlotBackground(Slot slot, TagKey<Item> backgroundTag, PoseStack pose, int mouseX, int mouseY, int counter) {
        int index = counter;
        if (!slot.m_6657_()) {
            List values = this.tagValues.computeIfAbsent(backgroundTag, $ -> RegistryHelper.getTags((IForgeRegistry)ForgeRegistries.ITEMS).getTag(backgroundTag).stream().map(Item::m_7968_).collect(Collectors.toList()));
            if (this.cycleCounter == 125 && ++index >= values.size()) {
                index = 0;
            }
            int x = this.f_97735_ + slot.f_40220_;
            int y = this.f_97736_ + slot.f_40221_;
            ItemStack stack = (ItemStack)values.get(index);
            Font stackFont = RenderProperties.get((Item)stack.m_41720_()).getFont(stack);
            stackFont = stackFont == null ? this.f_96547_ : stackFont;
            this.renderTranslucentItem(pose, stack, x, y);
            this.f_96542_.m_115169_(stackFont, stack, x, y);
            if (((FurnitureStationMenu)this.f_97732_).m_142621_().m_41619_() && mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
                Component name = stack.m_41786_();
                Component accepts = FurnitureStation.buildAcceptsAnyComponent(backgroundTag);
                this.renderTooltip(pose, Lists.newArrayList((Object[])new Component[]{name, accepts}), Optional.empty(), mouseX, mouseY, stackFont);
            }
        }
        return index;
    }

    private boolean isItemValid(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.searchBox == null) {
            return true;
        }
        if (!this.searchBox.m_94213_() || !this.searchBox.f_93623_) {
            return true;
        }
        String value = this.searchBox.m_94155_();
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String[] values = value.split("\\s+");
        Item item = stack.m_41720_();
        List tags = this.itemTags.computeIfAbsent(item, $ -> RegistryHelper.getTags((IForgeRegistry)ForgeRegistries.ITEMS).getReverseTag((IForgeRegistryEntry)item).map(t -> t.getTagKeys().collect(Collectors.toList())).orElse(Collections.emptyList()));
        String displayName = stack.m_41786_().getString();
        for (String filter : values) {
            if (filter.startsWith("#")) {
                String rawTagName = filter.substring(1);
                for (TagKey tag : tags) {
                    ResourceLocation tagName = tag.f_203868_();
                    String namespace = tagName.m_135827_();
                    String path = tagName.m_135815_();
                    if (!StringUtils.containsIgnoreCase((CharSequence)namespace, (CharSequence)rawTagName) && !StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)rawTagName)) continue;
                    return true;
                }
                continue;
            }
            if (filter.startsWith("@")) {
                String raw = filter.substring(1);
                String modId = item.getCreatorModId(stack);
                if (!StringUtils.containsIgnoreCase((CharSequence)modId, (CharSequence)raw)) continue;
                return true;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)displayName, (CharSequence)filter)) continue;
            return true;
        }
        return false;
    }

    private void renderResults(PoseStack pose, int mouseX, int mouseY) {
        List<ItemStack> results = ((FurnitureStationMenu)this.f_97732_).getResults();
        if (!results.isEmpty()) {
            Minecraft mc = this.getMinecraft();
            int centerX = (this.f_96543_ - this.f_97726_) / 2;
            int centerY = (this.f_96544_ - this.f_97727_) / 2;
            int yOffset = 0;
            boolean canHover = true;
            int maxY = centerY + 46 + 72;
            ItemStack selectedResult = ((FurnitureStationMenu)this.f_97732_).getResultSlot().m_7993_();
            int visibleItemIndex = 0;
            ItemStack hoveredStack = ItemStack.f_41583_;
            for (int j = this.startIndex; j < results.size(); ++j) {
                ItemStack resultItem = results.get(j);
                if (!this.isItemValid(resultItem)) continue;
                int resultItemX = centerX + 17 + 18 * (visibleItemIndex % 6);
                int resultItemY = centerY + 46 + yOffset;
                if (visibleItemIndex % 6 == 5) {
                    yOffset += 18;
                }
                if (resultItemY >= maxY) break;
                boolean isHovered = false;
                float vOffset = 0.0f;
                if (canHover) {
                    boolean bl = isHovered = mouseX >= resultItemX && mouseY >= resultItemY && mouseX < resultItemX + 18 && mouseY < resultItemY + 18;
                }
                if (isHovered) {
                    canHover = false;
                    vOffset = 36.0f;
                }
                if (!selectedResult.m_41619_() && ItemStack.m_41728_((ItemStack)selectedResult, (ItemStack)resultItem)) {
                    vOffset = 18.0f;
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                FurnitureStationMenuScreen.m_93133_((PoseStack)pose, (int)(resultItemX - 1), (int)(resultItemY - 1), (float)176.0f, (float)vOffset, (int)18, (int)18, (int)256, (int)256);
                Font stackFont = RenderProperties.get((Item)resultItem.m_41720_()).getFont(resultItem);
                stackFont = stackFont == null ? this.f_96547_ : stackFont;
                this.f_96542_.m_115123_(resultItem, resultItemX, resultItemY);
                this.f_96542_.m_115169_(stackFont, resultItem, resultItemX, resultItemY);
                if (isHovered && hoveredStack.m_41619_()) {
                    hoveredStack = resultItem;
                }
                ++visibleItemIndex;
            }
            if (!hoveredStack.m_41619_()) {
                this.m_6057_(pose, hoveredStack, mouseX, mouseY);
            }
        }
    }

    private boolean clickedResult(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        List<ItemStack> results = ((FurnitureStationMenu)this.f_97732_).getResults();
        if (!results.isEmpty()) {
            ItemStack selectedItem = ((FurnitureStationMenu)this.f_97732_).getResultSlot().m_7993_();
            int centerX = (this.f_96543_ - this.f_97726_) / 2;
            int centerY = (this.f_96544_ - this.f_97727_) / 2;
            int yOffset = 0;
            int maxY = centerY + 46 + 72;
            int visibleItemIndex = 0;
            for (int j = this.startIndex; j < results.size(); ++j) {
                ItemStack resultItem = results.get(j);
                if (!this.isItemValid(resultItem)) continue;
                boolean isSelected = false;
                if (!selectedItem.m_41619_() && ItemStack.m_41728_((ItemStack)selectedItem, (ItemStack)resultItem)) {
                    isSelected = true;
                }
                int resultItemX = centerX + 17 + 18 * (visibleItemIndex % 6);
                int resultItemY = centerY + 46 + yOffset;
                if (visibleItemIndex % 6 == 5) {
                    yOffset += 18;
                }
                if (resultItemY >= maxY) break;
                if (!isSelected && mouseX >= (double)resultItemX && mouseY >= (double)resultItemY && mouseX < (double)(resultItemX + 18) && mouseY < (double)(resultItemY + 18)) {
                    Minecraft mc = this.getMinecraft();
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                    ((FurnitureStationMenu)this.f_97732_).setSelectedResult(j);
                    ModInitializer.NETWORK.sendToServer((AbstractPacket)new C2SSyncSelectedResultPacket(j));
                    return true;
                }
                ++visibleItemIndex;
            }
        }
        return false;
    }

    private void renderTranslucentItem(PoseStack pose, ItemStack stack, int x, int y) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(pose.m_85850_().m_85861_());
        Font stackFont = RenderProperties.get((Item)stack.m_41720_()).getFont(stack);
        stackFont = stackFont == null ? this.f_96547_ : stackFont;
        this.f_96542_.m_115218_(stack, x, y);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)516);
        GuiComponent.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x30FFFFFF);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        this.f_96542_.m_115174_(stackFont, stack, x, y, null);
        modelViewStack.m_85849_();
    }

    private boolean scrollbarActive() {
        return ((FurnitureStationMenu)this.f_97732_).getResults().size() > 24;
    }
}

