/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Iterator;
import java.util.List;
import mezz.jei.common.util.ItemStackMatchable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MatchingIterable
implements Iterable<ItemStackMatchable<ItemStack>> {
    private final List<ItemStack> ingredients;

    public MatchingIterable(List<ItemStack> ingredients) {
        this.ingredients = ingredients;
    }

    @Override
    public Iterator<ItemStackMatchable<ItemStack>> iterator() {
        Iterator<ItemStack> stacks = this.ingredients.iterator();
        return new DelegateIterator<ItemStack, ItemStackMatchable<ItemStack>>(stacks){

            @Override
            public ItemStackMatchable<ItemStack> next() {
                final ItemStack stack = (ItemStack)this.delegate.next();
                return new ItemStackMatchable<ItemStack>(){

                    @Override
                    @Nullable
                    public ItemStack getStack() {
                        return stack;
                    }

                    @Override
                    @Nullable
                    public ItemStack getResult() {
                        return stack;
                    }
                };
            }
        };
    }

    public static abstract class DelegateIterator<T, R>
    implements Iterator<R> {
        protected final Iterator<T> delegate;

        public DelegateIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

