/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.util.function.Supplier;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.file.ConfigCategoryBuilder;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.core.search.SearchMode;

public class IngredientFilterConfig
implements IIngredientFilterConfig {
    public final Supplier<SearchMode> modNameSearchMode;
    public final Supplier<SearchMode> tooltipSearchMode;
    public final Supplier<SearchMode> tagSearchMode;
    public final Supplier<SearchMode> creativeTabSearchMode;
    public final Supplier<SearchMode> colorSearchMode;
    public final Supplier<SearchMode> resourceLocationSearchMode;
    public final Supplier<Boolean> searchAdvancedTooltips;

    public IngredientFilterConfig(ConfigSchemaBuilder builder) {
        ConfigCategoryBuilder search = builder.addCategory("search");
        this.modNameSearchMode = search.addEnum("ModNameSearchMode", SearchMode.REQUIRE_PREFIX, "Search mode for mod names (prefix: @).");
        this.tooltipSearchMode = search.addEnum("TooltipSearchMode", SearchMode.ENABLED, "Search mode for tooltips (prefix: #).");
        this.tagSearchMode = search.addEnum("TagSearchMode", SearchMode.REQUIRE_PREFIX, "Search mode for tags (prefix: $).");
        this.creativeTabSearchMode = search.addEnum("CreativeTabSearchMode", SearchMode.DISABLED, "Search mode for creative mode tab names (prefix: %).");
        this.colorSearchMode = search.addEnum("ColorSearchMode", SearchMode.DISABLED, "Search mode for colors (prefix: ^).");
        this.resourceLocationSearchMode = search.addEnum("ResourceLocationSearchMode", SearchMode.DISABLED, "Search mode for resource locations (prefix: &).");
        this.searchAdvancedTooltips = search.addBoolean("SearchAdvancedTooltips", false, "Search in advanced tooltips (visible with F3 + H).");
    }

    @Override
    public SearchMode getModNameSearchMode() {
        return this.modNameSearchMode.get();
    }

    @Override
    public SearchMode getTooltipSearchMode() {
        return this.tooltipSearchMode.get();
    }

    @Override
    public SearchMode getTagSearchMode() {
        return this.tagSearchMode.get();
    }

    @Override
    public SearchMode getCreativeTabSearchMode() {
        return this.creativeTabSearchMode.get();
    }

    @Override
    public SearchMode getColorSearchMode() {
        return this.colorSearchMode.get();
    }

    @Override
    public SearchMode getResourceLocationSearchMode() {
        return this.resourceLocationSearchMode.get();
    }

    @Override
    public boolean getSearchAdvancedTooltips() {
        return this.searchAdvancedTooltips.get();
    }
}

