/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import top.theillusivec4.veinmining.config.VeinMiningConfig;

public class VeinMiningEnchantment
extends Enchantment {
    public static final String ID = "veinmining:vein_mining";
    public static final Map<String, Predicate<ItemStack>> PREDICATE_MAP;
    public static final EnchantmentCategory CATEGORY;

    public VeinMiningEnchantment() {
        super(Enchantment.Rarity.RARE, CATEGORY, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    private static boolean canToolAction(ItemStack stack) {
        Set<ToolAction> actions = Set.of(ToolActions.PICKAXE_DIG, ToolActions.AXE_DIG, ToolActions.HOE_DIG, ToolActions.SHOVEL_DIG);
        for (ToolAction action : actions) {
            if (!stack.canPerformAction(action)) continue;
            return true;
        }
        return false;
    }

    private static boolean canToolAction(ToolAction toolAction, ItemStack stack) {
        return stack.canPerformAction(toolAction);
    }

    private static boolean canEnchantItem(Item item) {
        for (String entry : VeinMiningConfig.Enchantment.items) {
            if (item.getRegistryName() == null || !item.getRegistryName().toString().equals(entry)) continue;
            return true;
        }
        return item instanceof DiggerItem;
    }

    private static boolean canEnchantItem(ItemStack stack) {
        for (String entry : VeinMiningConfig.Enchantment.items) {
            if (PREDICATE_MAP.getOrDefault(entry, k -> false).test(stack)) {
                return true;
            }
            if (stack.m_41720_().getRegistryName() == null || !stack.m_41720_().getRegistryName().toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Enchantment.Rarity m_44699_() {
        return VeinMiningConfig.Enchantment.rarity;
    }

    public int m_6586_() {
        return VeinMiningConfig.Enchantment.levels;
    }

    public int m_6183_(int enchantmentLevel) {
        return VeinMiningConfig.Enchantment.minEnchantabilityBase + VeinMiningConfig.Enchantment.minEnchantabilityPerLevel * (enchantmentLevel - 1);
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 50;
    }

    public boolean m_6591_() {
        return VeinMiningConfig.Enchantment.isTreasure;
    }

    public boolean m_6594_() {
        return VeinMiningConfig.Enchantment.isVillagerTrade;
    }

    public boolean m_6592_() {
        return VeinMiningConfig.Enchantment.isLootable;
    }

    protected boolean m_5975_(Enchantment ench) {
        ResourceLocation rl = ench.getRegistryName();
        if (rl != null && VeinMiningConfig.Enchantment.incompatibleEnchantments.contains(rl.toString())) {
            return false;
        }
        return super.m_5975_(ench);
    }

    public boolean m_6081_(@Nonnull ItemStack pStack) {
        return VeinMiningEnchantment.canEnchantItem(pStack);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack pStack) {
        return this.m_6081_(pStack) && VeinMiningConfig.Enchantment.canApplyAtEnchantingTable;
    }

    public boolean isAllowedOnBooks() {
        return VeinMiningConfig.Enchantment.canApplyOnBooks;
    }

    static {
        CATEGORY = EnchantmentCategory.create((String)ID, VeinMiningEnchantment::canEnchantItem);
        HashMap<String, Predicate<ItemStack>> temp = new HashMap<String, Predicate<ItemStack>>();
        temp.put("is:tool", VeinMiningEnchantment::canToolAction);
        temp.put("is:pickaxe", stack -> VeinMiningEnchantment.canToolAction(ToolActions.PICKAXE_DIG, stack));
        temp.put("is:axe", stack -> VeinMiningEnchantment.canToolAction(ToolActions.AXE_DIG, stack));
        temp.put("is:hoe", stack -> VeinMiningEnchantment.canToolAction(ToolActions.HOE_DIG, stack));
        temp.put("is:shovel", stack -> VeinMiningEnchantment.canToolAction(ToolActions.SHOVEL_DIG, stack));
        PREDICATE_MAP = ImmutableMap.copyOf(temp);
    }
}

