/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining;

import net.minecraft.client.KeyMapping;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.veinmining.config.ClientVeinMiningConfig;
import top.theillusivec4.veinmining.config.VeinMiningConfig;
import top.theillusivec4.veinmining.network.VeinMiningNetwork;
import top.theillusivec4.veinmining.veinmining.VeinMiningEnchantment;
import top.theillusivec4.veinmining.veinmining.VeinMiningKey;
import top.theillusivec4.veinmining.veinmining.event.VeinMiningClientEventsListener;
import top.theillusivec4.veinmining.veinmining.event.VeinMiningEventsListener;
import top.theillusivec4.veinmining.veinmining.logic.BlockProcessor;

@Mod(value="veinmining")
public class VeinMiningMod {
    public static final String MOD_ID = "veinmining";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Enchantment VEIN_MINING = new VeinMiningEnchantment();

    public VeinMiningMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addGenericListener(Enchantment.class, this::registerEnchantment);
        eventBus.addListener(this::configLoading);
        eventBus.addListener(this::configReloading);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)VeinMiningConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientVeinMiningConfig.CONFIG_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent evt) {
        VeinMiningNetwork.register();
        MinecraftForge.EVENT_BUS.register((Object)new VeinMiningEventsListener());
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ClientRegistry.registerKeyBinding((KeyMapping)VeinMiningKey.get());
        MinecraftForge.EVENT_BUS.register((Object)new VeinMiningClientEventsListener());
    }

    private void registerEnchantment(RegistryEvent.Register<Enchantment> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)((Enchantment)VEIN_MINING.setRegistryName("veinmining:vein_mining")));
    }

    private void configLoading(ModConfigEvent.Loading evt) {
        this.bakeConfigs((ModConfigEvent)evt);
    }

    private void configReloading(ModConfigEvent.Reloading evt) {
        this.bakeConfigs((ModConfigEvent)evt);
    }

    private void bakeConfigs(ModConfigEvent evt) {
        ModConfig config = evt.getConfig();
        if (config.getModId().equals(MOD_ID)) {
            if (config.getType() == ModConfig.Type.CLIENT) {
                ClientVeinMiningConfig.bake();
            } else {
                VeinMiningConfig.bake();
                BlockProcessor.rebuild();
            }
        }
    }
}

