/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class ModIdentification
implements ResourceManagerReloadListener {
    public static final Map<String, String> NAMES = Maps.newConcurrentMap();
    public static final ModIdentification INSTANCE = new ModIdentification();

    public static void init() {
        NAMES.clear();
        ImmutableList mods = ImmutableList.copyOf((Collection)ModList.get().getMods());
        for (IModInfo mod : mods) {
            String modid = mod.getModId();
            String name = mod.getDisplayName();
            if (Strings.isNullOrEmpty((String)name)) {
                StringUtils.capitalize((String)modid);
            }
            NAMES.put(modid, name);
        }
    }

    public static String getModName(String namespace) {
        return NAMES.computeIfAbsent(namespace, $ -> {
            String key = "jade.modName." + namespace;
            if (I18n.m_118936_((String)key)) {
                return I18n.m_118938_((String)key, (Object[])new Object[0]);
            }
            return "Minecraft";
        });
    }

    public static String getModName(ResourceLocation id) {
        return ModIdentification.getModName(id.m_135827_());
    }

    public static String getModName(Block block) {
        return ModIdentification.getModName(block.getRegistryName());
    }

    public static String getModName(ItemStack stack) {
        return ModIdentification.getModName(stack.m_41720_().getCreatorModId(stack));
    }

    public static String getModName(Entity entity) {
        Motive motive;
        if (entity instanceof Painting && (motive = ((Painting)entity).f_31902_) != null) {
            return ModIdentification.getModName(motive.getRegistryName().m_135827_());
        }
        if (entity instanceof ItemEntity) {
            return ModIdentification.getModName(((ItemEntity)entity).m_32055_());
        }
        if (entity instanceof FallingBlockEntity) {
            return ModIdentification.getModName(((FallingBlockEntity)entity).m_31980_().m_60734_());
        }
        return ModIdentification.getModName(entity.m_6095_().getRegistryName());
    }

    public void m_6213_(ResourceManager manager) {
        ModIdentification.init();
    }

    static {
        ModIdentification.init();
    }
}

