/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.Collection;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.impl.WailaClientRegistration;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.JadeCommonConfig;

public class BaseBlockProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final BaseBlockProvider INSTANCE = new BaseBlockProvider();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        TooltipPosition position = accessor.getTooltipPosition();
        if (position == TooltipPosition.HEAD) {
            this.appendHead(tooltip, accessor, config);
        } else if (position == TooltipPosition.BODY) {
            this.appendBody(tooltip, accessor, config);
        } else if (position == TooltipPosition.TAIL) {
            this.appendTail(tooltip, accessor, config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHead(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        Object name = null;
        if (accessor.getServerData().m_128425_("givenName", 8)) {
            name = Component.Serializer.m_130701_((String)accessor.getServerData().m_128461_("givenName"));
        }
        if (name == null && accessor.isFakeBlock()) {
            name = accessor.getFakeBlock().m_41786_();
        }
        if (name == null && WailaClientRegistration.INSTANCE.shouldPick(accessor.getBlockState()) && !(pick = accessor.getPickedResult()).m_41619_()) {
            name = pick.m_41786_();
        }
        if (name == null) {
            ItemStack stack;
            String key = accessor.getBlock().m_7705_();
            name = I18n.m_118936_((String)key) ? accessor.getBlock().m_49954_() : ((stack = accessor.getBlockState().getCloneItemStack(accessor.getHitResult(), (BlockGetter)accessor.getLevel(), accessor.getPosition(), accessor.getPlayer())) != null && !stack.m_41619_() ? stack.m_41786_() : new TextComponent(key));
        }
        if (name != null) {
            WailaConfig wailaConfig = config.getWailaConfig();
            tooltip.add((Component)new TextComponent(String.format(wailaConfig.getFormatting().getBlockName(), name.getString())).m_130948_(wailaConfig.getOverlay().getColor().getTitle()), CorePlugin.TAG_OBJECT_NAME);
        }
        if (config.get(CorePlugin.CONFIG_REGISTRY_NAME)) {
            tooltip.add((Component)new TextComponent(accessor.getBlock().getRegistryName().toString()).m_130940_(ChatFormatting.GRAY), CorePlugin.TAG_REGISTRY_NAME);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendBody(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (config.get(CorePlugin.CONFIG_BLOCK_STATES)) {
            BlockState state = accessor.getBlockState();
            Collection properties = state.m_61147_();
            if (properties.isEmpty()) {
                return;
            }
            IElementHelper helper = tooltip.getElementHelper();
            ITooltip box = helper.tooltip();
            properties.forEach(p -> {
                Comparable value = state.m_61143_(p);
                MutableComponent valueText = new TextComponent(" " + value.toString()).m_130944_(new ChatFormatting[0]);
                if (p instanceof BooleanProperty) {
                    valueText = valueText.m_130940_(value == Boolean.TRUE ? ChatFormatting.GREEN : ChatFormatting.RED);
                }
                box.add((Component)new TextComponent(p.m_61708_() + ":").m_7220_((Component)valueText));
            });
            tooltip.add(helper.box(box));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendTail(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        ResourceLocation id;
        ItemStack fakeBlock;
        if (!config.get(CorePlugin.CONFIG_MOD_NAME)) {
            return;
        }
        String modName = null;
        if (accessor.isFakeBlock() && (fakeBlock = accessor.getFakeBlock()).m_41782_() && fakeBlock.m_41783_().m_128441_("id") && (id = ResourceLocation.m_135820_((String)fakeBlock.m_41783_().m_128461_("id"))) != null) {
            modName = ModIdentification.getModName(id);
        }
        if (modName == null && WailaClientRegistration.INSTANCE.shouldPick(accessor.getBlockState()) && !(pick = accessor.getPickedResult()).m_41619_()) {
            modName = ModIdentification.getModName(pick);
        }
        if (modName == null) {
            modName = ModIdentification.getModName(accessor.getBlock());
        }
        if (!Strings.isNullOrEmpty(modName)) {
            modName = String.format(config.getWailaConfig().getFormatting().getModName(), modName);
            IElementHelper helper = tooltip.getElementHelper();
            tooltip.add(helper.text((Component)new TextComponent(modName)).tag(CorePlugin.TAG_MOD_NAME));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity t, boolean showDetails) {
        Nameable nameable;
        if (t instanceof Nameable && JadeCommonConfig.shouldShowCustomName(t) && (nameable = (Nameable)t).m_8077_()) {
            data.m_128359_("givenName", Component.Serializer.m_130703_((Component)nameable.m_7770_()));
        }
    }
}

