/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.balm.api.config.Synced;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.IWaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;

@Config(name="waystones")
public class WaystonesConfigData
implements BalmConfigData,
IWaystonesConfig {
    @ConfigEntry.Gui.CollapsibleObject
    public XpCost xpCost = new XpCost();
    @ConfigEntry.Gui.CollapsibleObject
    public Restrictions restrictions = new Restrictions();
    @ConfigEntry.Gui.CollapsibleObject
    public Cooldowns cooldowns = new Cooldowns();
    @ConfigEntry.Gui.CollapsibleObject
    public InventoryButton inventoryButton = new InventoryButton();
    @ConfigEntry.Gui.CollapsibleObject
    public WorldGen worldGen = new WorldGen();
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();
    @ConfigEntry.Gui.CollapsibleObject
    public Compatibility compatibility = new Compatibility();

    @Override
    public boolean restrictToCreative() {
        return this.restrictions.restrictToCreative;
    }

    @Override
    public boolean generatedWaystonesUnbreakable() {
        return this.restrictions.generatedWaystonesUnbreakable;
    }

    @Override
    public boolean globalWaystoneRequiresCreative() {
        return this.restrictions.globalWaystoneSetupRequiresCreativeMode;
    }

    @Override
    public boolean restrictRenameToOwner() {
        return this.restrictions.restrictRenameToOwner;
    }

    @Override
    public boolean transportLeashed() {
        return this.restrictions.transportLeashed;
    }

    @Override
    public List<String> leashedDenyList() {
        return this.restrictions.leashedDenyList;
    }

    @Override
    public boolean transportLeashedDimensional() {
        return this.restrictions.transportLeashedDimensional;
    }

    @Override
    public DimensionalWarp dimensionalWarp() {
        return this.restrictions.dimensionalWarp;
    }

    @Override
    public List<String> dimensionalWarpAllowList() {
        return this.restrictions.dimensionalWarpAllowList;
    }

    @Override
    public List<String> dimensionalWarpDenyList() {
        return this.restrictions.dimensionalWarpDenyList;
    }

    @Override
    public boolean allowWaystoneToWaystoneTeleport() {
        return this.restrictions.allowWaystoneToWaystoneTeleport;
    }

    @Override
    public int inventoryButtonCooldown() {
        return this.cooldowns.inventoryButtonCooldown;
    }

    @Override
    public int warpStoneCooldown() {
        return this.cooldowns.warpStoneCooldown;
    }

    @Override
    public double globalWaystoneCooldownMultiplier() {
        return this.cooldowns.globalWaystoneCooldownMultiplier;
    }

    @Override
    public boolean inverseXpCost() {
        return this.xpCost.inverseXpCost;
    }

    @Override
    public int blocksPerXPLevel() {
        return this.xpCost.blocksPerXpLevel;
    }

    @Override
    public int dimensionalWarpXpCost() {
        return this.xpCost.dimensionalWarpXpCost;
    }

    @Override
    public double inventoryButtonXpCostMultiplier() {
        return this.xpCost.inventoryButtonXpCostMultiplier;
    }

    @Override
    public double warpStoneXpCostMultiplier() {
        return this.xpCost.warpStoneXpCostMultiplier;
    }

    @Override
    public double sharestoneXpCostMultiplier() {
        return this.xpCost.sharestoneXpCostMultiplier;
    }

    @Override
    public double waystoneXpCostMultiplier() {
        return this.xpCost.waystoneXpCostMultiplier;
    }

    @Override
    public double portstoneXpCostMultiplier() {
        return this.xpCost.portstoneXpCostMultiplier;
    }

    @Override
    public double warpPlateXpCostMultiplier() {
        return this.xpCost.warpPlateXpCostMultiplier;
    }

    @Override
    public double globalWaystoneXpCostMultiplier() {
        return this.xpCost.globalWaystoneXpCostMultiplier;
    }

    @Override
    public int xpCostPerLeashed() {
        return this.xpCost.xpCostPerLeashed;
    }

    @Override
    public int scrollUseTime() {
        return this.cooldowns.scrollUseTime;
    }

    @Override
    public int warpStoneUseTime() {
        return this.cooldowns.warpStoneUseTime;
    }

    @Override
    public List<String> customWaystoneNames() {
        return this.worldGen.customWaystoneNames;
    }

    @Override
    public boolean disableParticles() {
        return this.client.disableParticles;
    }

    @Override
    public double minimumXpCost() {
        return this.xpCost.minimumBaseXpCost;
    }

    @Override
    public double maximumXpCost() {
        return this.xpCost.maximumBaseXpCost;
    }

    @Override
    public String inventoryButton() {
        return this.inventoryButton.inventoryButton;
    }

    @Override
    public boolean disableTextGlow() {
        return this.client.disableTextGlow;
    }

    @Override
    public WorldGenStyle worldGenStyle() {
        return this.worldGen.worldGenStyle;
    }

    @Override
    public boolean spawnInVillages() {
        return this.worldGen.spawnInVillages;
    }

    @Override
    public boolean forceSpawnInVillages() {
        return this.worldGen.forceSpawnInVillages;
    }

    @Override
    public NameGenerationMode nameGenerationMode() {
        return this.worldGen.nameGenerationMode;
    }

    @Override
    public List<String> worldGenDimensionAllowList() {
        return this.worldGen.dimensionAllowList;
    }

    @Override
    public List<String> worldGenDimensionDenyList() {
        return this.worldGen.dimensionDenyList;
    }

    @Override
    public int worldGenFrequency() {
        return this.worldGen.frequency;
    }

    @Override
    public int creativeWarpButtonX() {
        return this.inventoryButton.creativeWarpButtonX;
    }

    @Override
    public int creativeWarpButtonY() {
        return this.inventoryButton.creativeWarpButtonY;
    }

    @Override
    public int warpButtonX() {
        return this.inventoryButton.warpButtonX;
    }

    @Override
    public int warpButtonY() {
        return this.inventoryButton.warpButtonY;
    }

    public static class XpCost {
        @Synced
        @Comment(value="Set to true if experience cost should be inverted, meaning the shorter the distance, the more expensive. Can be used to encourage other methods for short-distance travel.")
        public boolean inverseXpCost = false;
        @Synced
        @Comment(value="The amount of blocks per xp level requirement. If set to 500, the base xp cost for travelling 1000 blocks will be 2 levels.")
        public int blocksPerXpLevel = 1000;
        @Synced
        @Comment(value="The minimum base xp cost (may be subceeded by multipliers defined below)")
        public double minimumBaseXpCost = 0.0;
        @Synced
        @Comment(value="The maximum base xp cost (may be exceeded by multipliers defined below), set to 0 to disable all distance-based XP costs")
        public double maximumBaseXpCost = 3.0;
        @Synced
        @Comment(value="How much xp is needed per leashed animal to travel with you")
        public int xpCostPerLeashed = 1;
        @Synced
        @Comment(value="The base xp level cost when travelling between dimensions. Ignores block distance.")
        public int dimensionalWarpXpCost = 3;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting to a global waystone through any method.")
        public double globalWaystoneXpCostMultiplier = 1.0;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting using a Warp Stone item (not the Waystone block, Konstantin)")
        public double warpStoneXpCostMultiplier = 0.0;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting from one waystone to another.")
        public double waystoneXpCostMultiplier = 1.0;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting from one sharestone to another.")
        public double sharestoneXpCostMultiplier = 1.0;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting from a portstone.")
        public double portstoneXpCostMultiplier = 0.0;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting from one warp plate to another.")
        public double warpPlateXpCostMultiplier = 0.0;
        @Synced
        @Comment(value="The multiplier applied to the base xp cost when teleporting via the inventory button.")
        public double inventoryButtonXpCostMultiplier = 0.0;
    }

    public static class Restrictions {
        @Synced
        @Comment(value="If enabled, only creative players can place, edit or break waystones. This does NOT disable the crafting recipe.")
        public boolean restrictToCreative = false;
        @Synced
        @Comment(value="If enabled, only the owner of a waystone (the one who placed it) can rename it.")
        public boolean restrictRenameToOwner = false;
        @Synced
        @Comment(value="If enabled, waystones generated in worldgen are unbreakable.")
        public boolean generatedWaystonesUnbreakable = false;
        @Synced
        @Comment(value="If enabled, leashed mobs will be teleported with you")
        public boolean transportLeashed = true;
        @Synced
        @Comment(value="Whether to take leashed mobs with you when teleporting between dimensions")
        public boolean transportLeashedDimensional = true;
        @Comment(value="List of leashed mobs that cannot be taken with you when teleporting")
        @ExpectedType(value=String.class)
        public List<String> leashedDenyList = Lists.newArrayList((Object[])new String[]{"minecraft:wither"});
        @Synced
        @Comment(value="Set to 'ALLOW' to allow dimensional warp in general. Set to 'GLOBAL_ONLY' to restrict dimensional warp to global waystones. Set to 'DENY' to disallow all dimensional warps.")
        public DimensionalWarp dimensionalWarp = DimensionalWarp.ALLOW;
        @Comment(value="List of dimensions that players are allowed to warp cross-dimension from and to. If left empty, all dimensions except those in dimensionalWarpDenyList are allowed.")
        @ExpectedType(value=String.class)
        public List<String> dimensionalWarpAllowList = new ArrayList<String>();
        @Comment(value="List of dimensions that players are not allowed to warp cross-dimension from and to. Only used if dimensionalWarpAllowList is empty.")
        @ExpectedType(value=String.class)
        public List<String> dimensionalWarpDenyList = new ArrayList<String>();
        @Comment(value="Set to true if players should be able to teleport between waystones by simply right-clicking a waystone.")
        public boolean allowWaystoneToWaystoneTeleport = true;
        @Synced
        @Comment(value="Set to false to allow non-creative players to make waystones globally activated for all players.")
        public boolean globalWaystoneSetupRequiresCreativeMode = true;
    }

    public static class Cooldowns {
        @Synced
        @Comment(value="The multiplier applied to the cooldown when teleporting to a global waystone via inventory button or warp stone.")
        public double globalWaystoneCooldownMultiplier = 1.0;
        @Synced
        @Comment(value="The cooldown between usages of the warp stone in seconds. This is bound to the player, not the item, so multiple warp stones share the same cooldown.")
        public int warpStoneCooldown = 300;
        @Synced
        @Comment(value="The time in ticks that it takes to use a warp stone. This is the charge-up time when holding right-click.")
        public int warpStoneUseTime = 32;
        @Synced
        @Comment(value="The time in ticks that it takes to use a warp plate. This is the time the player has to stand on top for.")
        public int warpPlateUseTime = 20;
        @Synced
        @Comment(value="The time in ticks it takes to use a scroll. This is the charge-up time when holding right-click.")
        public int scrollUseTime = 32;
        @Synced
        @Comment(value="The cooldown between usages of the inventory button in seconds.")
        public int inventoryButtonCooldown = 300;
    }

    public static class InventoryButton {
        @Synced
        @Comment(value="Set to 'NONE' for no inventory button. Set to 'NEAREST' for an inventory button that teleports to the nearest waystone. Set to 'ANY' for an inventory button that opens the waystone selection menu. Set to a waystone name for an inventory button that teleports to a specifically named waystone.")
        public String inventoryButton = "";
        @Comment(value="The x position of the warp button in the inventory.")
        public int warpButtonX = 58;
        @Comment(value="The y position of the warp button in the inventory.")
        public int warpButtonY = 60;
        @Comment(value="The y position of the warp button in the creative menu.")
        public int creativeWarpButtonX = 88;
        @Comment(value="The y position of the warp button in the creative menu.")
        public int creativeWarpButtonY = 33;
    }

    public static class WorldGen {
        @Comment(value="Set to 'DEFAULT' to only generate the normally textured waystones. Set to 'MOSSY' or 'SANDY' to generate all as that variant. Set to 'BIOME' to make the style depend on the biome it is generated in.")
        public WorldGenStyle worldGenStyle = WorldGenStyle.BIOME;
        @Comment(value="Approximate chunk distance between waystones generated freely in world generation. Set to 0 to disable generation.")
        public int frequency = 25;
        @Comment(value="List of dimensions that waystones are allowed to spawn in through world gen. If left empty, all dimensions except those in worldGenDimensionDenyList are used.")
        @ExpectedType(value=String.class)
        public List<String> dimensionAllowList = Lists.newArrayList((Object[])new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
        @Comment(value="List of dimensions that waystones are not allowed to spawn in through world gen. Only used if worldGenDimensionAllowList is empty.")
        @ExpectedType(value=String.class)
        public List<String> dimensionDenyList = new ArrayList<String>();
        @Comment(value="Set to 'PRESET_FIRST' to first use names from the custom names list. Set to 'PRESET_ONLY' to use only those custom names. Set to 'MIXED' to have some waystones use custom names, and others random names.")
        public NameGenerationMode nameGenerationMode = NameGenerationMode.PRESET_FIRST;
        @Comment(value="These names will be used for the PRESET name generation mode. See the nameGenerationMode option for more info.")
        @ExpectedType(value=String.class)
        public List<String> customWaystoneNames = new ArrayList<String>();
        @Comment(value="Set to true if waystones should be added to the generation of villages. Some villages may still spawn without a waystone.")
        public boolean spawnInVillages = true;
        @Comment(value="Ensures that pretty much every village will have a waystone, by spawning it as early as possible. In addition, this means waystones will generally be located in the center of the village.")
        public boolean forceSpawnInVillages = false;
    }

    public static class Client {
        @Comment(value="If enabled, the text overlay on waystones will no longer always render at full brightness.")
        public boolean disableTextGlow = false;
        @Comment(value="If enabled, activated waystones will not emit particles.")
        public boolean disableParticles = false;
    }

    public static class Compatibility {
        @Comment(value="If enabled, JourneyMap waypoints will be created for each activated waystone.")
        public boolean displayWaystonesOnJourneyMap = true;
        @Comment(value="If enabled, JourneyMap waypoints will only be created if the mod 'JourneyMap Integration' is not installed")
        public boolean preferJourneyMapIntegration = true;
    }
}

