/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snowundertrees")
public class WorldTickHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START && event.world.m_46471_() && ((Boolean)Configuration.CONFIG.enableWhenSnowing.get()).booleanValue()) {
                ServerLevel level = (ServerLevel)event.world;
                level.m_7726_().f_8325_.m_140416_().forEach(chunkHolder -> {
                    Optional optional = chunkHolder.m_140073_().getNow(ChunkHolder.f_139997_).left();
                    if (optional.isPresent() && level.f_46441_.nextInt(16) == 0) {
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkPos = chunk.m_7697_();
                        int chunkX = chunkPos.m_45604_();
                        int chunkY = chunkPos.m_45605_();
                        BlockPos randomPos = level.m_46496_(chunkX, 0, chunkY, 15);
                        Biome biome = (Biome)level.m_204166_(randomPos).m_203334_();
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(level.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome).toString());
                        if (!biomeDisabled && level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, randomPos).m_7495_()).m_204336_(BlockTags.f_13035_)) {
                            BlockPos posBelow;
                            BlockState stateBelow;
                            BlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos);
                            if (SnowUnderTrees.isDynamicTreesLoaded()) {
                                pos = DynamicTreesHandler.findGround((WorldGenLevel)level, pos.m_122032_());
                            }
                            if (SnowUnderTrees.placeSnow((WorldGenLevel)level, pos) && (stateBelow = level.m_8055_(posBelow = pos.m_7495_())).m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                                level.m_7731_(posBelow, (BlockState)stateBelow.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    }
                });
            } else if (event.phase == TickEvent.Phase.END && SnowUnderTrees.isSereneSeasonsLoaded()) {
                SereneSeasonsHandler.tryMeltSnowUnderTrees(event);
            }
        }
    }
}

