/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.EternalWinterHandler;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowRealMagicHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="snowundertrees")
@Mod.EventBusSubscriber(modid="snowundertrees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnowUnderTrees {
    public static final String MODID = "snowundertrees";
    @ObjectHolder(value="snowundertrees:snow_under_trees")
    public static final Feature<NoneFeatureConfiguration> SNOW_UNDER_TREES_FEATURE = null;
    public static Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> snowUnderTreesConfiguredFeature;
    public static Holder<PlacedFeature> snowUnderTreesPlacedFeature;
    private static List<ResourceLocation> biomesToAddTo;
    private static boolean isSereneSeasonsLoaded;
    private static boolean isDynamicTreesLoaded;
    private static boolean isEternalWinterLoaded;
    private static BiFunction<WorldGenLevel, BlockPos, Boolean> snowPlaceFunction;
    private static BiFunction<WorldGenLevel, BlockPos, Boolean> temperatureCheck;
    private static BiFunction<WorldGenLevel, BlockPos, Boolean> isSnowCheck;
    private static PropertyDispatch.TriFunction<BlockState, WorldGenLevel, BlockPos, BlockState> stateAfterMeltingGetter;

    public SnowUnderTrees() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.addListener(SnowUnderTrees::onBiomeLoading);
        isSereneSeasonsLoaded = ModList.get().isLoaded("sereneseasons");
        isDynamicTreesLoaded = ModList.get().isLoaded("dynamictrees");
        isEternalWinterLoaded = ModList.get().isLoaded("eternalwinter");
        if (ModList.get().isLoaded("snowrealmagic")) {
            snowPlaceFunction = (level, pos) -> SnowRealMagicHandler.placeSnow(level, pos);
            isSnowCheck = (level, pos) -> SnowRealMagicHandler.isSnow(level, pos);
            stateAfterMeltingGetter = (stateNow, level, pos) -> SnowRealMagicHandler.getStateAfterMelting(stateNow, level, pos);
        } else {
            snowPlaceFunction = (level, pos) -> {
                BlockState state;
                if (SnowUnderTrees.canSnow(level, pos) && (state = level.m_8055_(pos)).m_60795_() && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, pos)) {
                    level.m_7731_(pos, Blocks.f_50125_.m_49966_(), 2);
                    return true;
                }
                return false;
            };
            isSnowCheck = (level, pos) -> level.m_8055_(pos).m_60734_() == Blocks.f_50125_;
            stateAfterMeltingGetter = (stateNow, level, pos) -> Blocks.f_50016_.m_49966_();
        }
        temperatureCheck = isSereneSeasonsLoaded ? (level, pos) -> !SereneSeasonsHandler.warmEnoughToRain(level, (Holder<Biome>)level.m_204166_(pos), pos) : (level, pos) -> !((Biome)level.m_204166_(pos).m_203334_()).m_198906_(pos);
    }

    @SubscribeEvent
    public static void onRegisterFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((Feature)new SnowUnderTreesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_).setRegistryName("snow_under_trees")));
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            snowUnderTreesConfiguredFeature = FeatureUtils.m_206485_((String)"snowundertrees:snow_under_trees", SNOW_UNDER_TREES_FEATURE);
            snowUnderTreesPlacedFeature = PlacementUtils.m_206513_((String)"snowundertrees:snow_under_trees", snowUnderTreesConfiguredFeature, (PlacementModifier[])new PlacementModifier[]{BiomeFilter.m_191561_()});
        });
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)Configuration.CONFIG.enableBiomeFeature.get()).booleanValue()) {
            boolean isEternalWinterActive;
            boolean bl = isEternalWinterActive = isEternalWinterLoaded && EternalWinterHandler.isActive(event.getName());
            if (isEternalWinterActive || (event.getClimate().f_47680_ == Biome.Precipitation.SNOW || event.getClimate().f_47681_ < 0.15f || biomesToAddTo.contains(event.getName())) && !((List)Configuration.CONFIG.filteredBiomes.get()).contains(event.getName().toString())) {
                event.getGeneration().m_204193_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION.ordinal(), snowUnderTreesPlacedFeature);
            }
        }
    }

    public static void addSnowUnderTrees(Biome biome) {
        if (!biomesToAddTo.contains(biome.getRegistryName())) {
            biomesToAddTo.add(biome.getRegistryName());
        }
    }

    public static boolean placeSnow(WorldGenLevel level, BlockPos pos) {
        return snowPlaceFunction.apply(level, pos);
    }

    public static boolean canSnow(WorldGenLevel level, BlockPos pos) {
        if (temperatureCheck.apply(level, pos).booleanValue() && SnowUnderTrees.isInBuildRangeAndDarkEnough(level, pos)) {
            BlockPos posBelow = pos.m_7495_();
            BlockState stateBelow = level.m_8055_(posBelow);
            return stateBelow.m_60783_((BlockGetter)level, posBelow, Direction.UP);
        }
        return false;
    }

    public static boolean isSnow(WorldGenLevel level, BlockPos pos) {
        return isSnowCheck.apply(level, pos);
    }

    public static BlockState getStateAfterMelting(BlockState stateNow, WorldGenLevel level, BlockPos pos) {
        return (BlockState)stateAfterMeltingGetter.m_125475_((Object)stateNow, (Object)level, (Object)pos);
    }

    private static final boolean isInBuildRangeAndDarkEnough(WorldGenLevel level, BlockPos pos) {
        return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() < level.m_151558_() && level.m_45517_(LightLayer.BLOCK, pos) < 10;
    }

    public static boolean isSereneSeasonsLoaded() {
        return isSereneSeasonsLoaded;
    }

    public static boolean isDynamicTreesLoaded() {
        return isDynamicTreesLoaded;
    }

    public static boolean isEternalWinterLoaded() {
        return isEternalWinterLoaded;
    }

    static {
        biomesToAddTo = new ArrayList<ResourceLocation>();
    }
}

