/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IFlowerModelProvider;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class FlowerPotHandler {
    private static Map<Block, Map<ResourceLocation, Supplier<? extends Block>>> FULL_POTS;
    private static final List<BlockState> FULL_POTs_BLOCKSTATES_LIST;
    private static final Map<Item, ResourceLocation> SPECIAL_FLOWER_BOX_FLOWERS;
    public static final List<ResourceLocation> CUSTOM_MODELS;

    public static BlockState getAprilPot() {
        int ind = (int)(System.currentTimeMillis() / 15000L % (long)FULL_POTs_BLOCKSTATES_LIST.size());
        return FULL_POTs_BLOCKSTATES_LIST.get(ind);
    }

    public static Block getFullPot(FlowerPotBlock emptyPot, Block flowerBlock) {
        return FULL_POTS.get(emptyPot.getEmptyPot()).getOrDefault(flowerBlock.getRegistryName(), (Supplier<? extends Block>)Blocks.f_50016_.delegate).get();
    }

    public static boolean isEmptyPot(Block b) {
        return FULL_POTS != null && b != null && FULL_POTS.containsKey(b);
    }

    public static void init() {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(((Item)ModRegistry.FLAX_ITEM.get()).getRegistryName(), ModRegistry.FLAX_POT);
        HashSet<FlowerPotBlock> emptyPots = new HashSet<FlowerPotBlock>();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof FlowerPotBlock)) continue;
            emptyPots.add(((FlowerPotBlock)b).getEmptyPot());
        }
        FULL_POTS = Maps.newHashMap();
        for (FlowerPotBlock pot : emptyPots) {
            FULL_POTS.put((Block)pot, pot.getFullPotsView());
            FULL_POTs_BLOCKSTATES_LIST.addAll(pot.getFullPotsView().values().stream().map(s -> ((Block)s.get()).m_49966_()).collect(Collectors.toList()));
        }
    }

    public static void registerCustomFlower(Item item2, ResourceLocation model) {
        SPECIAL_FLOWER_BOX_FLOWERS.put(item2, model);
    }

    private static void registerCompatFlower(String itemRes) {
        Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemRes));
        if (item2 != null && item2 != Items.f_41852_) {
            ResourceLocation res = Supplementaries.res("block/plants/" + item2.getRegistryName().m_135815_());
            CUSTOM_MODELS.add(res);
            FlowerPotHandler.registerCustomFlower(item2, res);
        }
    }

    @Nullable
    public static ResourceLocation getSpecialFlowerModel(Item i) {
        BlockItem blockItem;
        Block block2;
        ResourceLocation res = SPECIAL_FLOWER_BOX_FLOWERS.get(i);
        if (res != null) {
            return res;
        }
        if (i instanceof IFlowerModelProvider) {
            IFlowerModelProvider flowerModelProvider = (IFlowerModelProvider)i;
            return flowerModelProvider.getModel();
        }
        if (i instanceof BlockItem && (block2 = (blockItem = (BlockItem)i).m_40614_()) instanceof IFlowerModelProvider) {
            IFlowerModelProvider flowerModelProvider = (IFlowerModelProvider)block2;
            return flowerModelProvider.getModel();
        }
        return null;
    }

    public static boolean hasSpecialFlowerModel(Item i) {
        return FlowerPotHandler.getSpecialFlowerModel(i) != null;
    }

    static {
        FULL_POTs_BLOCKSTATES_LIST = new ArrayList<BlockState>();
        SPECIAL_FLOWER_BOX_FLOWERS = new HashMap<Item, ResourceLocation>();
        CUSTOM_MODELS = new ArrayList<ResourceLocation>();
        ArrayList<String> toAdd = new ArrayList<String>();
        toAdd.add(Items.f_41982_.getRegistryName().toString());
        toAdd.add(Items.f_151013_.getRegistryName().toString());
        toAdd.add(Items.f_151012_.getRegistryName().toString());
        toAdd.add(((Item)ModRegistry.FLAX_SEEDS_ITEM.get()).getRegistryName().toString());
        if (ModList.get().isLoaded("snowyspirit")) {
            toAdd.add("snowyspirit:ginger_flower");
        }
        if (CompatHandler.quark) {
            Item[] items2 = new Item[]{Items.f_41909_, Items.f_42733_, Items.f_42619_, Items.f_42003_, Items.f_42620_, Items.f_41864_, Items.f_42533_, Items.f_42404_, Items.f_42029_, Items.f_42211_, Items.f_42780_, Items.f_41907_, Items.f_41906_, Items.f_42578_, Items.f_42577_, Items.f_42210_, Items.f_41868_, Items.f_42588_};
            toAdd.add("quark:chorus_weeds");
            toAdd.add("quark:root");
            toAdd.add("quark:chorus_twist");
            Arrays.stream(items2).forEach(i -> toAdd.add(i.getRegistryName().toString()));
        }
        if (CompatHandler.pokecube_legends) {
            toAdd.add("pokecube_legends:crystallized_cactus");
        }
        if (CompatHandler.pokecube) {
            String[] berries = new String[]{"pokecube:berry_aspear", "pokecube:berry_cheri", "pokecube:berry_chesto", "pokecube:berry_cornn", "pokecube:berry_enigma", "pokecube:berry_grepa", "pokecube:berry_hondew", "pokecube:berry_jaboca", "pokecube:berry_kelpsy", "pokecube:berry_leppa", "pokecube:berry_lum", "pokecube:berry_nanab", "pokecube:berry_null", "pokecube:berry_oran", "pokecube:berry_pecha", "pokecube:berry_persim", "pokecube:berry_pinap", "pokecube:berry_pomeg", "pokecube:berry_qualot", "pokecube:berry_rawst", "pokecube:berry_rowap", "pokecube:berry_sitrus", "pokecube:berry_tamato"};
            toAdd.addAll(Arrays.asList(berries));
        }
        if (CompatHandler.moreminecarts) {
            toAdd.add("moreminecarts:chunkrodite_block");
            toAdd.add("moreminecarts:glass_cactus");
        }
        if (CompatHandler.habitat) {
            toAdd.add("habitat:rafflesia");
            toAdd.add("habitat:orange_ball_cactus");
            toAdd.add("habitat:red_ball_cactus");
            toAdd.add("habitat:pink_ball_cactus");
            toAdd.add("habitat:yellow_ball_cactus");
            toAdd.add("habitat:kabloom_pulp");
        }
        if (CompatHandler.endergetic) {
            toAdd.add("endergetic:tall_poise_bush");
        }
        if (CompatHandler.simplefarming) {
            toAdd.add("simplefarming:cantaloupe_block");
            toAdd.add("simplefarming:honeydew_block");
            toAdd.add("simplefarming:squash_block");
        }
        if (CompatHandler.atmospheric) {
            toAdd.add("atmospheric:barrel_cactus");
        }
        toAdd.forEach(FlowerPotHandler::registerCompatFlower);
    }
}

