/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetPresentPacket {
    private final BlockPos pos;
    private final boolean packed;
    private final String sender;
    private final String recipient;
    private final String description;

    public ServerBoundSetPresentPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.packed = buf.readBoolean();
        this.recipient = buf.m_130277_();
        this.sender = buf.m_130277_();
        this.description = buf.m_130277_();
    }

    public ServerBoundSetPresentPacket(BlockPos pos, boolean packed, String recipient, String sender, String description) {
        this.pos = pos;
        this.packed = packed;
        this.recipient = recipient;
        this.sender = sender;
        this.description = description;
    }

    public static void buffer(ServerBoundSetPresentPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeBoolean(message.packed);
        buf.m_130070_(message.recipient);
        buf.m_130070_(message.sender);
        buf.m_130070_(message.description);
    }

    public static void handler(ServerBoundSetPresentPacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = Objects.requireNonNull(ctx.get().getSender());
        Level world = player.f_19853_;
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            BlockEntity patt1974$temp = world.m_7702_(message.pos);
            if (patt1974$temp instanceof PresentBlockTile) {
                PresentBlockTile present = (PresentBlockTile)patt1974$temp;
                present.updateState(message.packed, message.recipient, message.sender, message.description);
                BlockState state = world.m_8055_(pos);
                present.m_6596_();
                world.m_7260_(pos, state, state, 3);
                if (message.packed) {
                    player.m_9230_();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

