/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.mehvahdjukaar.selene.fluids.FoodProvider;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.util.PotionNBTHelper;
import net.mehvahdjukaar.supplementaries.client.renderers.items.JarItemRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.tabs.JarTab;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.botania.BotaniaCompatRegistry;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class JarItem
extends AbstractMobContainerItem {
    private JarBlockTile DUMMY_TILE = null;

    public JarItem(Block blockIn, Item.Properties properties) {
        super(blockIn, properties, 0.625f, 0.875f, true);
    }

    @Override
    public boolean canItemCatch(Entity e) {
        LivingEntity le;
        EntityType type = e.m_6095_();
        if (e instanceof Monster) {
            return false;
        }
        if (ServerConfigs.cached.JAR_AUTO_DETECT && this.canFitEntity(e)) {
            return true;
        }
        return type.m_204039_(ModTags.JAR_CATCHABLE) || type.m_204039_(ModTags.CAGE_BABY_CATCHABLE) && e instanceof LivingEntity && (le = (LivingEntity)e).m_6162_() || this.isBoat(e) || CapturedMobsHelper.is2DFish(type);
    }

    @Override
    public void playReleaseSound(Level world, Vec3 v) {
        world.m_6263_(null, v.m_7096_(), v.m_7098_(), v.m_7094_(), SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 0.05f);
    }

    @Override
    public void playCatchSound(Player player) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public ItemStack saveEntityInItem(Entity entity2, ItemStack currentStack, ItemStack bucket) {
        if (this.isBoat(entity2)) {
            return new ItemStack((ItemLike)ModRegistry.JAR_BOAT_ITEM.get());
        }
        return super.saveEntityInItem(entity2, currentStack, bucket);
    }

    public boolean isBoat(Entity e) {
        return e instanceof Boat;
    }

    @Override
    public InteractionResult doInteract(ItemStack stack, Player player, Entity entity2, InteractionHand hand) {
        if (!ServerConfigs.cached.JAR_CAPTURE) {
            return InteractionResult.PASS;
        }
        return super.doInteract(stack, player, entity2, hand);
    }

    @Override
    public boolean blocksPlacement() {
        return ServerConfigs.cached.JAR_CAPTURE;
    }

    @Override
    public void addPlacementTooltip(List<Component> tooltip) {
        if (ServerConfigs.cached.JAR_CAPTURE) {
            super.addPlacementTooltip(tooltip);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
        if (compoundTag == null) {
            if (!ClientConfigs.cached.TOOLTIP_HINTS || !flagIn.m_7050_()) {
                return;
            }
            tooltip.add((Component)new TranslatableComponent("message.supplementaries.jar").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        } else {
            if (compoundTag.m_128425_("LootTable", 8)) {
                tooltip.add((Component)new TextComponent("???????").m_130940_(ChatFormatting.GRAY));
            }
            if (compoundTag.m_128441_("FluidHolder")) {
                CompoundTag com = compoundTag.m_128469_("FluidHolder");
                SoftFluid s = SoftFluidRegistry.get((String)com.m_128461_("Fluid"));
                int count = com.m_128451_("Count");
                if (!s.isEmpty() && count > 0) {
                    String bottle;
                    CompoundTag nbt = null;
                    Object add = "";
                    if (com.m_128441_("NBT") && (nbt = com.m_128469_("NBT")).m_128441_("Bottle") && !(bottle = nbt.m_128461_("Bottle").toLowerCase(Locale.ROOT)).equals("regular")) {
                        add = "_" + bottle;
                    }
                    tooltip.add((Component)new TranslatableComponent("message.supplementaries.fluid_tooltip", new Object[]{new TranslatableComponent(s.getTranslationKey() + (String)add), count}).m_130940_(ChatFormatting.GRAY));
                    if (nbt != null) {
                        PotionNBTHelper.addPotionTooltip((CompoundTag)nbt, tooltip, (float)1.0f);
                        return;
                    }
                }
            }
            if (compoundTag.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent iformattabletextcomponent = itemstack.m_41786_().m_6881_();
                    String s = iformattabletextcomponent.getString();
                    s = s.replace(" Bucket", "");
                    s = s.replace(" Bottle", "");
                    s = s.replace("Bucket of ", "");
                    TextComponent str = new TextComponent(s);
                    str.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)str.m_130940_(ChatFormatting.GRAY));
                }
                if (j - i > 0) {
                    tooltip.add((Component)new TranslatableComponent("container.shulkerBox.more", new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items2) {
        if (((Boolean)RegistryConfigs.Reg.JAR_TAB.get()).booleanValue()) {
            if (group == ModRegistry.JAR_TAB) {
                JarTab.populateTab(items2);
            }
        } else {
            super.m_6787_(group, items2);
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        CompoundTag com;
        SoftFluid s;
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("FluidHolder") && (s = SoftFluidRegistry.get((String)(com = tag.m_128469_("FluidHolder")).m_128461_("Fluid"))) == ModSoftFluids.DIRT.get()) {
            return Rarity.RARE;
        }
        return super.m_41460_(stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity2) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && entity2 instanceof Player) {
            JarBlockTile temp = new JarBlockTile(entity2.m_20097_(), ((Block)ModRegistry.JAR.get()).m_49966_());
            temp.m_142466_(tag);
            SoftFluidHolder fh = temp.getSoftFluidHolder();
            if (fh.containsFood() && fh.tryDrinkUpFluid((Player)entity2, world)) {
                CompoundTag newTag = new CompoundTag();
                temp.m_183515_(newTag);
                stack.m_41700_("BlockEntityTag", (Tag)newTag);
                return stack;
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        if (this.m_8105_(playerEntity.m_21120_(hand)) != 0) {
            return ItemUtils.m_150959_((Level)world, (Player)playerEntity, (InteractionHand)hand);
        }
        return super.m_7203_(world, playerEntity, hand);
    }

    public int m_8105_(ItemStack stack) {
        CompoundTag tag;
        if (ServerConfigs.cached.JAR_ITEM_DRINK && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            if (this.DUMMY_TILE == null) {
                this.DUMMY_TILE = new JarBlockTile(BlockPos.f_121853_, ((Block)ModRegistry.JAR.get()).m_49966_());
            }
            this.DUMMY_TILE.m_142466_(tag);
            SoftFluidHolder fh = this.DUMMY_TILE.getSoftFluidHolder();
            FoodProvider provider = fh.getFluid().get().getFoodProvider();
            Item food = provider.getFood();
            return food.m_8105_(food.m_7968_()) / provider.getDivider();
        }
        return 0;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (ServerConfigs.cached.JAR_ITEM_DRINK) {
            return UseAnim.DRINK;
        }
        return UseAnim.NONE;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        ClientRegistry.registerISTER(consumer, JarItemRenderer::new);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult r;
        if (CompatHandler.botania && this == ModRegistry.JAR_ITEM.get() && (r = BotaniaCompatRegistry.tryCaptureTater(this, context)).m_19077_()) {
            return r;
        }
        return super.m_6225_(context);
    }
}

