/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.api.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.selene.api.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.selene.math.MthUtils;
import net.mehvahdjukaar.selene.util.TwoHandedAnimation;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BubbleBlock;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSounds;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BubbleBlower
extends Item
implements IThirdPersonAnimationProvider,
IFirstPersonAnimationProvider {
    public BubbleBlower(Item.Properties properties) {
        super(properties);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public InteractionResultHolder<ItemStack> deployBubbleBlock(ItemStack stack, Level level, Player player, InteractionHand hand) {
        HitResult result;
        HitResult hitResult = result = player.m_150110_().f_35937_ ? CommonUtil.rayTrace((LivingEntity)player, level, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY) : CommonUtil.rayTrace((Entity)player, level, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, 2.6);
        if (result instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)result;
            BlockPos pos = hitResult2.m_82425_();
            BlockState first = level.m_8055_(pos);
            if (!first.m_60767_().m_76336_()) {
                pos = pos.m_142300_(hitResult2.m_82434_());
            }
            if ((first = level.m_8055_(pos)).m_60767_().m_76336_()) {
                BlockState bubble = ((BubbleBlock)((Object)ModRegistry.BUBBLE_BLOCK.get())).m_49966_();
                SoundType soundtype = bubble.getSoundType((LevelReader)level, pos, (Entity)player);
                level.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                if (!level.f_46443_) {
                    level.m_46597_(pos, bubble);
                }
                if (!player.m_150110_().f_35937_) {
                    int max = this.getMaxDamage(stack);
                    this.setDamage(stack, Math.min(max, this.getDamage(stack) + ServerConfigs.cached.BUBBLE_BLOWER_COST));
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int m_142159_(ItemStack stack) {
        return 15246564;
    }

    public int getMaxDamage(ItemStack stack) {
        return 250;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        ListTag enchantments = EnchantedBookItem.m_41163_((ItemStack)book);
        return enchantments.size() == 1 && EnchantmentHelper.m_182446_((CompoundTag)enchantments.m_128728_(0)).equals((Object)EnchantmentHelper.m_182432_((Enchantment)((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get())));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.getCharges(stack) != 0) {
            tooltip.add((Component)new TranslatableComponent("message.supplementaries.bubble_blower_tooltip", new Object[]{stack.m_41776_() - stack.m_41773_(), stack.m_41776_()}));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getCharges(stack) > 0;
    }

    private int getCharges(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        int charges = this.getCharges(itemstack);
        if (charges > 0) {
            int ench = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get()), (ItemStack)itemstack);
            if (ench > 0) {
                return this.deployBubbleBlock(itemstack, level, player, hand);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity2, int count) {
        int soundLength;
        Player player;
        Level level = entity2.f_19853_;
        int damage = this.getDamage(stack) + 1;
        if (damage > this.getMaxDamage(stack)) {
            entity2.m_5810_();
            return;
        }
        if (!(entity2 instanceof Player) || !(player = (Player)entity2).m_7500_()) {
            this.setDamage(stack, damage);
        }
        if (count % (soundLength = 4) == 0) {
            Player pl;
            Player p = entity2 instanceof Player ? (pl = (Player)entity2) : null;
            entity2.f_19853_.m_6269_(p, (Entity)entity2, (SoundEvent)ModSounds.BUBBLE_BLOW.get(), entity2.m_5720_(), 1.0f, MthUtils.nextWeighted((Random)level.f_46441_, (float)0.2f) + 0.95f);
        }
        if (level.f_46443_) {
            Vec3 v = entity2.m_20252_(0.0f).m_82541_();
            double x = entity2.m_20185_() + v.f_82479_;
            double y = entity2.m_20188_() + v.f_82480_ - 0.12;
            double z = entity2.m_20189_() + v.f_82481_;
            Random r = entity2.m_21187_();
            v = v.m_82490_(0.1 + (double)(r.nextFloat() * 0.1f));
            double dx = v.f_82479_ + (0.5 - (double)r.nextFloat()) * 0.08;
            double dy = v.f_82480_ + (0.5 - (double)r.nextFloat()) * 0.04;
            double dz = v.f_82481_ + (0.5 - (double)r.nextFloat()) * 0.08;
            level.m_7106_((ParticleOptions)ModRegistry.SUDS_PARTICLE.get(), x, y, z, dx, dy, dz);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity2, HumanoidArm mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.m_21212_() > 0 && entity2.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity2, true);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity2, HumanoidArm mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.m_21212_() > 0 && entity2.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity2, false);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity2, boolean leftHand) {
        ModelPart mainHand = leftHand ? model.f_102812_ : model.f_102811_;
        int dir = leftHand ? -1 : 1;
        float cr = entity2.m_6047_() ? 0.3f : 0.0f;
        float headXRot = RotHlpr.wrapRad(model.f_102808_.f_104203_);
        float headYRot = RotHlpr.wrapRad(model.f_102808_.f_104204_);
        float pitch = Mth.m_14036_((float)headXRot, (float)-1.6f, (float)0.8f) + 0.55f - cr;
        mainHand.f_104203_ = (float)((double)pitch - 1.5707963267948966) - (float)dir * 0.3f * headYRot;
        float yaw = 0.7f * (float)dir;
        mainHand.f_104204_ = Mth.m_14036_((float)(-yaw * Mth.m_14089_((float)(pitch + cr)) + headYRot), (float)-1.1f, (float)1.1f);
        mainHand.f_104205_ = -yaw * Mth.m_14031_((float)(pitch + cr));
        AnimationUtils.m_170341_((ModelPart)mainHand, (float)entity2.f_19797_, (float)(-dir));
    }

    public void animateItemFirstPerson(LivingEntity entity2, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity2.m_6117_() && entity2.m_21212_() > 0 && entity2.m_7655_() == hand) {
            float timeLeft = (float)stack.m_41779_() - ((float)entity2.m_21212_() - partialTicks + 1.0f);
            float f12 = 1.0f;
            if (f12 > 0.1f) {
                float f15 = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
                float f18 = f12 - 0.1f;
                float f20 = f15 * f18;
                matrixStack.m_85837_(0.0, (double)(f20 * 0.004f), 0.0);
            }
            matrixStack.m_85837_(0.0, 0.0, (double)(f12 * 0.04f));
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }
}

