/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CapturedMobCache {
    public static LoadingCache<UUID, Entity> MOB_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, Entity>(){

        public Entity load(UUID key) {
            return null;
        }
    });
    private static EndCrystal pedestalCrystal = null;
    private static Entity defaultPig = null;

    public static void addMob(Entity e) {
        if (e == null) {
            e = CapturedMobCache.getPig();
        }
        MOB_CACHE.put((Object)e.m_142081_(), (Object)e);
    }

    public static EndCrystal getCrystal() {
        if (pedestalCrystal == null) {
            pedestalCrystal = new EndCrystal(EntityType.f_20564_, (Level)Minecraft.m_91087_().f_91073_);
            pedestalCrystal.m_31056_(false);
        }
        return pedestalCrystal;
    }

    @NotNull
    public static Entity getPig() {
        if (defaultPig == null) {
            defaultPig = new Pig(EntityType.f_20510_, (Level)Minecraft.m_91087_().f_91073_);
        }
        return defaultPig;
    }

    @Nullable
    public static Entity getOrCreateCachedMob(UUID id, CompoundTag tag) {
        ClientLevel world;
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)id);
        if (e == null && (world = Minecraft.m_91087_().f_91073_) != null) {
            CompoundTag mobData = tag.m_128469_("EntityData");
            e = MobContainer.createEntityFromNBT(mobData, id, (Level)world);
            CapturedMobCache.addMob(e);
        }
        return e;
    }

    public static void tickCrystal() {
        if (pedestalCrystal != null) {
            ++CapturedMobCache.pedestalCrystal.f_31032_;
        }
    }

    public static void unloadLevel() {
        pedestalCrystal = null;
        defaultPig = null;
        MOB_CACHE.invalidateAll();
    }
}

