/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WallLanternTexturesRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<Block, ResourceLocation> SPECIAL_TEXTURES = new HashMap<Block, ResourceLocation>();
    private static Set<Block> POSSIBLE_LANTERNS = null;

    public WallLanternTexturesRegistry() {
        super(GSON, "textures/blocks/wall_lanterns");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager manager, ProfilerFiller pProfiler) {
        WallLanternTexturesRegistry.reloadTextures(manager);
    }

    public static void reloadTextures(ResourceManager manager) {
        if (POSSIBLE_LANTERNS == null) {
            WallLanternTexturesRegistry.init();
        }
        SPECIAL_TEXTURES.clear();
        for (Block i : POSSIBLE_LANTERNS) {
            ResourceLocation reg = i.getRegistryName();
            String namespace = reg.m_135827_().equals("minecraft") || reg.m_135827_().equals("supplementaries") ? "" : reg.m_135827_() + "/";
            String s = "textures/blocks/wall_lanterns/" + namespace + reg.m_135815_() + ".json";
            ResourceLocation fullPath = Supplementaries.res(s);
            try {
                Resource resource = manager.m_142591_(fullPath);
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)resource.m_6679_());
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_TEXTURES.put(i, new ResourceLocation(texture));
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (Exception exception) {}
        }
        ResourceLocation fullPath = Supplementaries.res("textures/blocks/jar_fluid.json");
        try (Resource resource = manager.m_142591_(fullPath);){
            JsonObject bsElement = RPUtils.deserializeJson((InputStream)resource.m_6679_());
            float width = GsonHelper.m_13915_((JsonObject)bsElement, (String)"width") / 16.0f;
            float height = GsonHelper.m_13915_((JsonObject)bsElement, (String)"height") / 16.0f;
            float y0 = GsonHelper.m_13915_((JsonObject)bsElement, (String)"y") / 16.0f;
            JarBlockTileRenderer.liquidParams.m_122245_(width, height, y0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void init() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Block i : ForgeRegistries.BLOCKS) {
            if (!CommonUtil.isLanternBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS = builder.build();
    }

    @Nullable
    public static TextureAtlasSprite getTextureForLantern(Block block2) {
        ResourceLocation res = SPECIAL_TEXTURES.get(block2);
        if (res == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(res);
    }
}

