/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.registry.IRegistryObject;
import net.minecraft.resources.ResourceLocation;

public interface IRegistryEntries<V>
extends Iterable<V> {
    public <VT extends V> IRegistryObject<VT> add(Supplier<VT> var1, ResourceLocation var2);

    public Map<ResourceLocation, V> getEntries();

    public void addInsertListener(BiConsumer<ResourceLocation, IRegistryObject<? extends V>> var1);

    public void addRegistryListener(BiConsumer<ResourceLocation, V> var1);

    public void addRegistryWrapper(BiFunction<ResourceLocation, V, V> var1);

    public void build(BiConsumer<ResourceLocation, V> var1);

    @Nullable
    default public V getEntry(ResourceLocation id) {
        return this.getEntries().get(id);
    }

    @Nullable
    default public V getOrDefault(ResourceLocation key, V fallback) {
        return (V)this.getOrDefault(key, () -> fallback);
    }

    @Nullable
    default public V getOrDefault(ResourceLocation key, Supplier<V> fallback) {
        V value = this.getEntries().get(key);
        return value != null || this.getEntries().containsKey(key) ? value : fallback.get();
    }

    default public void ifPresent(ResourceLocation key, BiConsumer<ResourceLocation, V> consumer) {
        V value = this.getEntries().get(key);
        if (value != null || this.getEntries().containsKey(key)) {
            consumer.accept(key, value);
        }
    }

    default public void ifAbsent(ResourceLocation key, Consumer<ResourceLocation> consumer) {
        if (!this.getEntries().containsKey(key)) {
            consumer.accept(key);
        }
    }
}

