/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.melody.resources.audio.openal;

import de.keksuccino.melody.resources.audio.openal.ALErrorHandler;
import de.keksuccino.melody.resources.audio.openal.ALException;
import de.keksuccino.melody.resources.audio.openal.ALUtils;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;

public class ALAudioBuffer {
    private ByteBuffer dataBuffer;
    private final AudioFormat audioFormat;
    private boolean bufferPrepared;
    private Integer source;

    public ALAudioBuffer(@NotNull ByteBuffer dataBuffer, @NotNull AudioFormat audioFormat) {
        this.dataBuffer = Objects.requireNonNull(dataBuffer);
        this.audioFormat = Objects.requireNonNull(audioFormat);
    }

    @Nullable
    public Integer getSource() {
        return this.prepare() ? this.source : null;
    }

    public boolean prepare() {
        try {
            if (!this.bufferPrepared) {
                this.bufferPrepared = true;
                int audioFormat = ALUtils.getAudioFormatAsOpenAL(this.audioFormat);
                int[] bufferSource = new int[1];
                AL10.alGenBuffers((int[])bufferSource);
                ALErrorHandler.checkOpenAlError();
                this.source = bufferSource[0];
                AL10.alBufferData((int)bufferSource[0], (int)audioFormat, (ByteBuffer)this.dataBuffer, (int)((int)this.audioFormat.getSampleRate()));
                ALErrorHandler.checkOpenAlError();
                this.dataBuffer = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.dataBuffer = null;
            return false;
        }
        return true;
    }

    public void delete() throws ALException {
        this.bufferPrepared = false;
        if (this.isValidOpenAlSource()) {
            AL10.alDeleteBuffers((int[])new int[]{this.source});
            ALErrorHandler.checkOpenAlError();
        }
    }

    public void deleteQuietly() {
        this.bufferPrepared = false;
        if (this.isValidOpenAlSource()) {
            AL10.alDeleteBuffers((int[])new int[]{this.source});
            ALErrorHandler.getOpenAlError();
        }
    }

    public boolean isValidOpenAlSource() {
        if (this.source == null) {
            return false;
        }
        return this.bufferPrepared && AL10.alIsBuffer((int)this.source);
    }
}

