/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.serialization.Codec;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.worldgen.ConfigDensityFunction;
import dev.worldgen.tectonic.worldgen.DynamicReferenceDensityFunction;
import dev.worldgen.tectonic.worldgen.ErosionNoiseDensityFunction;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathResourcePack;

@Mod(value="tectonic")
public class TectonicForge {
    private static final List<String> enabledPacks = new ArrayList<String>();
    private static final DeferredRegister<Codec<? extends DensityFunction>> DF_REGISTER = DeferredRegister.create((ResourceKey)Registry.f_211075_, (String)"tectonic");
    private static final RegistryObject<Codec<? extends DensityFunction>> CONFIG = DF_REGISTER.register("config", () -> ConfigDensityFunction.CODEC);
    private static final RegistryObject<Codec<? extends DensityFunction>> DYNAMIC_REFERENCE = DF_REGISTER.register("dynamic_reference", () -> DynamicReferenceDensityFunction.CODEC);
    private static final RegistryObject<Codec<? extends DensityFunction>> EROSION_NOISE = DF_REGISTER.register("erosion_noise", () -> ErosionNoiseDensityFunction.CODEC);

    public TectonicForge() {
        Tectonic.init((Codec<HolderSet<DensityFunction>>)RegistryCodecs.m_206277_((ResourceKey)Registry.f_211074_));
        ConfigHandler.load(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        ConfigHandler.getConfig().enablePacks(ModList.get().isLoaded("terralith"), enabledPacks::add);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerEnabledPacks);
        DF_REGISTER.register(modEventBus);
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (String packName : enabledPacks) {
                this.registerDatapack(event, packName);
            }
        }
    }

    private void registerDatapack(AddPackFindersEvent event, String packName) {
        boolean enableBullshitFix = packName.equals("increased_height");
        try {
            Path datapackPath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + packName.toLowerCase()});
            PathResourcePack datapack = new PathResourcePack(ModList.get().getModFileById("tectonic").getFile().getFileName() + ":" + datapackPath, datapackPath);
            PackMetadataSection mcmeta = (PackMetadataSection)datapack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
            if (mcmeta != null) {
                event.addRepositorySource((consumer, constructor) -> consumer.accept(constructor.m_143873_("tectonic/" + (enableBullshitFix ? "z" : "") + packName.toLowerCase(), Component.m_130674_((String)packName), true, () -> datapack, mcmeta, Pack.Position.TOP, PackSource.f_10528_)));
            }
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
    }
}

