/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.sound_redirect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.network.PlayDragonSoundS2CPacket;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundRedirectUtil {
    public static final String BITE = "bite";
    public static final String STING = "sting";
    public static final String MELEE_ATTACK = "melee_attack";
    public static final String FIRE = "fire";
    public static final String FIRE_WEAK = "fire_weak";
    public static final String TAME = "tame";
    public static final String SLEEP = "sleep";
    public static final String GROWL = "growl";
    public static final String FLAP = "flap";
    public static final String HURT = "hurt";
    public static final String DEATH = "death";
    public static final String STEP = "step";
    private static final Map<String, Map<String, Map<String, SoundInfo>>> soundCache = new HashMap<String, Map<String, Map<String, SoundInfo>>>();
    public static final Map<String, Map<String, List<SoundRedirect>>> soundRedirectMap = new HashMap<String, Map<String, List<SoundRedirect>>>();

    public static <T extends Entity & DragonSpeciesHelper> boolean playSound(@NotNull T entity, String sound) {
        SoundInfo soundInfo = null;
        if (entity.m_8077_() && ModelRedirectUtil.isNametagAccessible(((DragonSpeciesHelper)entity).getSpecies(entity.f_19853_.m_5776_()), entity.m_7755_().getString().toLowerCase())) {
            soundInfo = SoundRedirectUtil.getSoundInfo(((DragonSpeciesHelper)entity).getSpecies(false), entity.m_7755_().getString().toLowerCase(), sound);
        }
        if (soundInfo == null) {
            soundInfo = SoundRedirectUtil.getSoundInfo(((DragonSpeciesHelper)entity).getSpecies(false), ((VariantNameHelper)entity).getVariantName(), sound);
        }
        if (soundInfo != null) {
            if (entity.f_19853_.m_5776_()) {
                entity.f_19853_.m_6269_((Player)entity.f_19853_.m_6907_().stream().filter(Player::m_7578_).findFirst().orElse(null), entity, new SoundEvent(soundInfo.id()), entity.m_5720_(), soundInfo.volume(), soundInfo.pitch());
            } else {
                for (Player player : entity.m_183503_().m_6907_()) {
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlayDragonSoundS2CPacket.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayDragonSoundS2CPacket(entity.m_142049_(), soundInfo.id(), soundInfo.pitch(), soundInfo.pitch()));
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Nullable
    public static SoundInfo getSoundInfo(String dragon, String variant, String sound) {
        SoundRedirectUtil.generateCache(dragon, variant, sound);
        return (SoundInfo)soundCache.getOrDefault(dragon, Collections.emptyMap()).getOrDefault(variant, Collections.emptyMap()).get(sound);
    }

    private static void generateCache(String dragon, String variant, String sound) {
        SoundInfo soundInfo = SoundRedirectUtil.getSoundInfoFromRedirects(dragon, variant, sound);
        Map variantMap = soundCache.computeIfAbsent(dragon, k -> new HashMap());
        Map soundInfoMap = variantMap.computeIfAbsent(variant, k -> new HashMap());
        soundInfoMap.put(sound, soundInfo);
    }

    @Nullable
    private static SoundInfo getSoundInfoFromRedirects(String dragon, String variant, String sound) {
        Map<String, List<SoundRedirect>> variantRedirectMap = soundRedirectMap.get(dragon);
        if (variantRedirectMap == null || !variantRedirectMap.containsKey(variant)) {
            return null;
        }
        List<SoundRedirect> soundInfos = variantRedirectMap.get(variant);
        return soundInfos.stream().filter(namedSoundInfo -> namedSoundInfo.name().equals(sound)).findFirst().map(SoundInfo::fromNamed).orElse(null);
    }

    public static void clearCahce() {
        soundCache.clear();
    }

    public static synchronized void add(String dragon, Map<String, List<SoundRedirect>> redirects) {
        Map<String, List<SoundRedirect>> content = soundRedirectMap.get(dragon);
        if (content != null) {
            for (Map.Entry<String, List<SoundRedirect>> entry : content.entrySet()) {
                String variant = entry.getKey();
                if (!redirects.containsKey(variant)) continue;
                ArrayList copy = new ArrayList();
                copy.addAll(redirects.get(variant));
                copy.addAll(entry.getValue());
                redirects.put(variant, copy);
            }
            content.putAll(redirects);
            soundRedirectMap.put(dragon, content);
        } else {
            soundRedirectMap.put(dragon, redirects);
        }
    }

    public static void debugPrint() {
        if (!((Boolean)IoBVariantLoader.config.logSoundRedirects.get()).booleanValue()) {
            return;
        }
        for (Map.Entry<String, Map<String, List<SoundRedirect>>> entry : soundRedirectMap.entrySet()) {
            for (Map.Entry<String, List<SoundRedirect>> extrasEntry : entry.getValue().entrySet()) {
                StringBuilder info = new StringBuilder();
                for (SoundRedirect redirect : extrasEntry.getValue()) {
                    info.append("Sound: ").append(redirect.name()).append("\n");
                    info.append("-  Id: ").append(redirect.sound()).append("\n");
                    info.append("-  Volume: ").append(redirect.volume()).append("\n");
                    info.append("-  Pitch: ").append(redirect.pitch()).append("\n");
                    info.append("\n");
                }
                IoBVariantLoader.LOGGER.info("{}: variant {} was redirected to:\n{}", new Object[]{entry.getKey(), extrasEntry.getKey(), info});
            }
        }
    }

    public record SoundInfo(ResourceLocation id, float volume, float pitch) {
        public static SoundInfo fromNamed(SoundRedirect namedSoundInfo) {
            return new SoundInfo(new ResourceLocation(namedSoundInfo.sound()), namedSoundInfo.volume(), namedSoundInfo.pitch());
        }
    }
}

