/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.sound_redirect;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirect;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirectUtil;

public class SoundRedirectReloadListener
extends SimpleJsonResourceReloadListener {
    public SoundRedirectReloadListener() {
        super(new GsonBuilder().create(), "sound_redirects");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        SoundRedirectUtil.soundRedirectMap.clear();
        SoundRedirectUtil.clearCahce();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            String dragon;
            ResourceLocation fileID = entry.getKey();
            JsonObject entryObject = entry.getValue().getAsJsonObject();
            String string = dragon = entryObject.has("dragon") ? entryObject.get("dragon").getAsString() : fileID.m_135815_();
            if (!ResourceUtil.AllowedValues.isValid(dragon, false)) {
                IoBVariantLoader.LOGGER.warn("Sound redirect entry {} does not match any dragon id and will be skipped", (Object)fileID);
                continue;
            }
            HashMap<String, List<SoundRedirect>> toPut = new HashMap<String, List<SoundRedirect>>();
            JsonArray array = entryObject.get("redirects").getAsJsonArray();
            for (JsonElement elem : array) {
                JsonObject input = elem.getAsJsonObject();
                String name = input.get("name").getAsString();
                if (!input.has("sounds")) continue;
                List soundRedirect = (List)SoundRedirect.CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)input.getAsJsonArray("sounds")).getOrThrow(false, error -> {
                    IoBVariantLoader.LOGGER.error("Failed to parse sound redirect data file {} correctly. Check for syntax errors and try again", (Object)fileID.toString());
                    IoBVariantLoader.LOGGER.error(error);
                });
                toPut.put(name, soundRedirect);
            }
            SoundRedirectUtil.add(dragon, toPut);
        }
        SoundRedirectUtil.debugPrint();
    }
}

