/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.model_redirect;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirect;
import org.jetbrains.annotations.Nullable;

public final class ModelRedirectUtil {
    public static final Map<String, Map<String, ModelRedirect>> dragonModelRedirects = new HashMap<String, Map<String, ModelRedirect>>();
    public static final Map<String, Map<String, String>> eggItemModelRedirects = new HashMap<String, Map<String, String>>();

    public static ResourceLocation getCustomTexturePath(ADragonBase dragon, String id) {
        return ModelRedirectUtil.getCustomTexturePath(dragon, id, "");
    }

    public static ResourceLocation getCustomTexturePath(ADragonBase dragon, String id, String suffix) {
        String model = ModelRedirectUtil.getTexture(id, ResourceUtil.parseName(dragon), suffix, dragon.m_6162_());
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "textures/dragons/" + id + "/" + model);
    }

    public static ResourceLocation getVariantTexturePath(String variant, String id, boolean isBaby) {
        return ModelRedirectUtil.getVariantTexturePath(variant, id, "", isBaby);
    }

    public static ResourceLocation getVariantTexturePath(String variant, String id, String suffix, boolean isBaby) {
        String model = ModelRedirectUtil.getTexture(id, variant, suffix, isBaby);
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "textures/dragons/" + id + "/" + model);
    }

    public static String getTexture(String dragon, String name, String suffix, boolean isBaby) {
        name = name.toLowerCase();
        if (dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name)) {
            if (isBaby && dragonModelRedirects.get(dragon).get(name).babyTexture().isPresent()) {
                return dragonModelRedirects.get(dragon).get(name).babyTexture().get();
            }
            return dragonModelRedirects.get(dragon).get(name).texture().isEmpty() ? name + suffix + ".png" : dragonModelRedirects.get(dragon).get(name).texture().get();
        }
        return name + suffix + ".png";
    }

    public static ResourceLocation getCustomModelPath(ADragonBase dragon, String dragonID) {
        String name = ResourceUtil.parseName(dragon);
        String model = ModelRedirectUtil.getModel(dragonID, name, dragon.m_6162_());
        if (ModelRedirectUtil.shouldApplyFix(dragon, dragonID, name, () -> dragonModelRedirects.get(dragonID).get(name).model().orElse(""))) {
            return new ResourceLocation("isleofberk", "geo/dragons/" + dragonID + ".geo.json");
        }
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "geo/dragons/" + dragonID + "/" + model);
    }

    public static ResourceLocation getVariantModelPath(ADragonBase dragon, String dragonID) {
        String model = ModelRedirectUtil.getModel(dragonID, ((VariantNameHelper)dragon).getVariantName(), dragon.m_6162_());
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "geo/dragons/" + dragonID + "/" + model);
    }

    public static String getModel(String dragon, String name, boolean isBaby) {
        name = name.toLowerCase();
        if (dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name)) {
            if (isBaby && dragonModelRedirects.get(dragon).get(name).babyModel().isPresent()) {
                return dragonModelRedirects.get(dragon).get(name).babyModel().get();
            }
            return dragonModelRedirects.get(dragon).get(name).model().isEmpty() ? ".json" : dragonModelRedirects.get(dragon).get(name).model().get();
        }
        return ".json";
    }

    public static ResourceLocation getCustomAnimationPath(ADragonBase dragon, String dragonID) {
        String name = ResourceUtil.parseName(dragon);
        String model = ModelRedirectUtil.getAnimation(dragonID, name, dragon.m_6162_());
        if (ModelRedirectUtil.shouldApplyFix(dragon, dragonID, name, () -> dragonModelRedirects.get(dragonID).get(name).animation().orElse(""))) {
            if (dragonID.equals("night_light")) {
                return new ResourceLocation("isleofberk", "animations/dragons/night_fury.animation.json");
            }
            return new ResourceLocation("isleofberk", "animations/dragons/" + dragonID + ".animation.json");
        }
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "animations/dragons/" + dragonID + "/" + model);
    }

    public static ResourceLocation getVariantAnimationPath(ADragonBase dragon, String dragonID) {
        String model = ModelRedirectUtil.getAnimation(dragonID, ((VariantNameHelper)dragon).getVariantName(), dragon.m_6162_());
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "animations/dragons/" + dragonID + "/" + model);
    }

    public static String getAnimation(String dragon, String name, boolean isBaby) {
        name = name.toLowerCase();
        if (dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name)) {
            if (isBaby && dragonModelRedirects.get(dragon).get(name).babyAnimation().isPresent()) {
                return dragonModelRedirects.get(dragon).get(name).babyAnimation().get();
            }
            return dragonModelRedirects.get(dragon).get(name).animation().isEmpty() ? ".json" : dragonModelRedirects.get(dragon).get(name).animation().get();
        }
        return ".json";
    }

    public static ResourceLocation getCustomSaddlePath(ADragonBase dragon, String dragonID) {
        String name = ResourceUtil.parseName(dragon);
        String model = ModelRedirectUtil.getSaddle(dragonID, name, dragon.m_6162_());
        if (ModelRedirectUtil.shouldApplyFix(dragon, dragonID, name, () -> dragonModelRedirects.get(dragonID).get(name).saddle().orElse(""))) {
            return new ResourceLocation("isleofberk", "textures/dragons/" + dragonID + "/equipment.png");
        }
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "textures/dragons/" + dragonID + "/" + model);
    }

    public static ResourceLocation getVariantSaddlePath(ADragonBase dragon, String dragonID) {
        String model = ModelRedirectUtil.getSaddle(dragonID, ((VariantNameHelper)dragon).getVariantName(), dragon.m_6162_());
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "textures/dragons/" + dragonID + "/" + model);
    }

    public static String getSaddle(String dragon, String name, boolean isBaby) {
        name = name.toLowerCase();
        if (dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name)) {
            if (isBaby && dragonModelRedirects.get(dragon).get(name).babySaddle().isPresent()) {
                return dragonModelRedirects.get(dragon).get(name).babySaddle().get();
            }
            return dragonModelRedirects.get(dragon).get(name).saddle().isEmpty() ? ".png" : dragonModelRedirects.get(dragon).get(name).saddle().get();
        }
        return ".png";
    }

    @Nullable
    public static String getEggItemModel(String dragon, String name) {
        name = name.toLowerCase();
        if (eggItemModelRedirects.containsKey(dragon)) {
            return eggItemModelRedirects.get(dragon).get(name);
        }
        return null;
    }

    public static <T extends ADragonEggBase> String getEggFolder(T entity) {
        String dragonID;
        ResourceLocation resourcelocation = EntityType.m_20613_((EntityType)entity.m_6095_());
        return switch (dragonID = resourcelocation.m_135815_().replace("_egg", "")) {
            case "m_nightmare" -> "monstrous_nightmare";
            case "nadder" -> "deadly_nadder";
            case "night_fury" -> "nightfury";
            case "speed_stinger" -> "speedstinger";
            case "triple_stryke" -> "triplestryke";
            case "gronckle" -> "gronkle";
            default -> dragonID;
        };
    }

    public static <T extends ADragonEggBase> ResourceLocation getEggTexture(T entity) {
        String dragon = ((DragonSpeciesHelper)entity).getSpecies(true);
        String name = ((VariantNameHelper)entity).getVariantName().toLowerCase();
        if (!(dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name) && dragonModelRedirects.get(dragon).get(name).eggTexture().isPresent())) {
            return null;
        }
        String texture = dragonModelRedirects.get(dragon).get(name).eggTexture().get();
        if (texture.contains(":")) {
            return new ResourceLocation(texture);
        }
        return new ResourceLocation("isleofberk", "textures/egg/" + ModelRedirectUtil.getEggFolder(entity) + "/" + texture);
    }

    public static <T extends ADragonEggBase> ResourceLocation getEggModel(T entity) {
        String dragon = ((DragonSpeciesHelper)entity).getSpecies(true);
        String name = ((VariantNameHelper)entity).getVariantName().toLowerCase();
        if (!(dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name) && dragonModelRedirects.get(dragon).get(name).eggModel().isPresent())) {
            return null;
        }
        String model = dragonModelRedirects.get(dragon).get(name).eggModel().get();
        if (model.contains(":")) {
            return new ResourceLocation(model);
        }
        return new ResourceLocation("isleofberk", "geo/egg/" + dragon + "/" + model);
    }

    public static boolean isNametagAccessible(String dragon, String name) {
        if (dragonModelRedirects.containsKey(dragon) && dragonModelRedirects.get(dragon).containsKey(name)) {
            return dragonModelRedirects.get(dragon).get(name).nametagAccessible();
        }
        return true;
    }

    public static synchronized void add(String dragon, Map<String, ModelRedirect> redirects) {
        Map<String, ModelRedirect> content = dragonModelRedirects.get(dragon);
        if (content != null) {
            content.putAll(redirects);
            dragonModelRedirects.put(dragon, content);
        } else {
            dragonModelRedirects.put(dragon, redirects);
        }
    }

    public static synchronized void addEggItemModels(String dragon, Map<String, String> redirects) {
        Map<String, String> content = eggItemModelRedirects.get(dragon);
        if (content != null) {
            content.putAll(redirects);
            eggItemModelRedirects.put(dragon, content);
        } else {
            eggItemModelRedirects.put(dragon, redirects);
        }
    }

    public static void debugPrint() {
        if (!((Boolean)IoBVariantLoader.clientConfig.logModelRedirects.get()).booleanValue()) {
            return;
        }
        for (Map.Entry<String, Map<String, ModelRedirect>> entry : dragonModelRedirects.entrySet()) {
            for (Map.Entry<String, ModelRedirect> redirects : entry.getValue().entrySet()) {
                ModelRedirect modelRedirect = redirects.getValue();
                StringBuilder modelRedirectInfo = new StringBuilder();
                if (modelRedirect.model().isPresent()) {
                    modelRedirectInfo.append("Model: ").append(modelRedirect.model()).append("\n");
                }
                if (modelRedirect.animation().isPresent()) {
                    modelRedirectInfo.append("Animation: ").append(modelRedirect.animation()).append("\n");
                }
                if (modelRedirect.texture().isPresent()) {
                    modelRedirectInfo.append("Texture: ").append(modelRedirect.texture()).append("\n");
                }
                if (modelRedirect.saddle().isPresent()) {
                    modelRedirectInfo.append("Saddle: ").append(modelRedirect.saddle()).append("\n");
                }
                if (modelRedirect.babyModel().isPresent()) {
                    modelRedirectInfo.append("Baby Model: ").append(modelRedirect.babyModel()).append("\n");
                }
                if (modelRedirect.babyAnimation().isPresent()) {
                    modelRedirectInfo.append("Baby Animation: ").append(modelRedirect.babyAnimation()).append("\n");
                }
                if (modelRedirect.babyTexture().isPresent()) {
                    modelRedirectInfo.append("Baby Texture: ").append(modelRedirect.babyTexture()).append("\n");
                }
                if (modelRedirect.babySaddle().isPresent()) {
                    modelRedirectInfo.append("Baby Saddle: ").append(modelRedirect.babySaddle()).append("\n");
                }
                if (modelRedirect.eggModel().isPresent()) {
                    modelRedirectInfo.append("Egg Model: ").append(modelRedirect.eggModel()).append("\n");
                }
                if (modelRedirect.eggTexture().isPresent()) {
                    modelRedirectInfo.append("Egg Texture: ").append(modelRedirect.eggTexture()).append("\n");
                }
                if (modelRedirect.eggItemName().isPresent()) {
                    modelRedirectInfo.append("Egg Item Name: ").append(modelRedirect.eggItemName().get()).append("\n");
                }
                if (eggItemModelRedirects.containsKey(entry.getKey()) && eggItemModelRedirects.get(entry.getKey()).containsKey(redirects.getKey())) {
                    modelRedirectInfo.append("Egg Item Model: ").append(eggItemModelRedirects.get(entry.getKey()).get(redirects.getKey())).append("\n");
                }
                if (modelRedirect.eggName().isPresent()) {
                    modelRedirectInfo.append("Egg Name: ").append(modelRedirect.eggName().get()).append("\n");
                }
                if (modelRedirect.dragonName().isPresent()) {
                    modelRedirectInfo.append("Dragon Name: ").append(modelRedirect.dragonName().get()).append("\n");
                }
                modelRedirectInfo.append("Is Accessible via Nametag: ").append(modelRedirect.nametagAccessible()).append("\n");
                IoBVariantLoader.LOGGER.info("{}: variant {} was redirected to:\n{}", new Object[]{entry.getKey(), redirects.getKey(), modelRedirectInfo});
            }
        }
        if (((Boolean)IoBVariantLoader.clientConfig.generateTranslations.get()).booleanValue()) {
            String dragon;
            System.out.println("==================================================================================");
            System.out.println("ISLE OF BERK VARIANT LOADER TRANSLATION KEY AUTOGENERATOR");
            System.out.println("==================================================================================");
            HashMap dragonVariants = new HashMap();
            for (Map.Entry<String, Map<String, ModelRedirect>> entry : dragonModelRedirects.entrySet()) {
                dragon = entry.getKey();
                for (Map.Entry<String, ModelRedirect> redirects : entry.getValue().entrySet()) {
                    String key = redirects.getKey();
                    if (((List)IoBVariantLoader.clientConfig.ignoredByGenerator.get()).contains(key)) continue;
                    if (!dragonVariants.containsKey(dragon)) {
                        dragonVariants.put(dragon, new ArrayList());
                    }
                    ((List)dragonVariants.get(dragon)).add(key);
                }
            }
            for (Map.Entry<String, Map<String, ModelRedirect>> entry : dragonVariants.entrySet()) {
                dragon = entry.getKey();
                for (String key : (List)((Object)entry.getValue())) {
                    System.out.println("\"item.iobvariantloader.egg." + dragon + "." + key + "\": \"" + ModelRedirectUtil.parseName(key) + " " + ModelRedirectUtil.parseName(dragon) + " Egg\",");
                }
            }
            System.out.println();
            for (Map.Entry<String, Map<String, ModelRedirect>> entry : dragonVariants.entrySet()) {
                dragon = entry.getKey();
                for (String key : (List)((Object)entry.getValue())) {
                    System.out.println("\"tooltip.iobvariantloader." + dragon + "." + key + "\": \"" + ModelRedirectUtil.parseName(key) + "\",");
                }
            }
            System.out.println();
            for (Map.Entry<String, Map<String, ModelRedirect>> entry : dragonVariants.entrySet()) {
                dragon = entry.getKey();
                for (String key : (List)((Object)entry.getValue())) {
                    System.out.println("\"entity.iobvariantloader.egg." + dragon + "." + key + "\": \"" + ModelRedirectUtil.parseName(key) + " " + ModelRedirectUtil.parseName(dragon) + " Egg\",");
                }
            }
            System.out.println();
            for (Map.Entry<String, Map<String, ModelRedirect>> entry : dragonVariants.entrySet()) {
                dragon = entry.getKey();
                for (String key : (List)((Object)entry.getValue())) {
                    System.out.println("\"entity.iobvariantloader." + dragon + "." + key + "\": \"" + ModelRedirectUtil.parseName(key) + " " + ModelRedirectUtil.parseName(dragon) + "\",");
                }
            }
            System.out.println("==================================================================================");
        }
    }

    private static String parseName(String name) {
        while (name.contains("_")) {
            int index = name.indexOf("_");
            if (index + 1 < name.length()) {
                String toReplace = String.valueOf(name.charAt(index + 1));
                name = name.replaceFirst("_" + toReplace, " " + toReplace.toUpperCase());
                continue;
            }
            name = name.replace("_", " ");
        }
        name = name.replace(" N ", " & ");
        String firstLetter = String.valueOf(name.charAt(0));
        return name.replaceFirst(firstLetter, firstLetter.toUpperCase());
    }

    public static void registerEggItemModelRedirects(ResourceManager manager) {
        eggItemModelRedirects.clear();
        Collection resourceCollection = manager.m_6540_("model_redirects", path -> path.endsWith(".json"));
        for (ResourceLocation id : resourceCollection) {
            String path2 = id.m_135815_();
            String dragon = "";
            HashMap<String, String> redirects = new HashMap<String, String>();
            try {
                InputStream stream = manager.m_142591_(id).m_6679_();
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    JsonElement element = JsonParser.parseReader((Reader)bufferedReader);
                    String string = dragon = element.getAsJsonObject().has("dragon") ? element.getAsJsonObject().get("dragon").getAsString() : path2.substring(path2.lastIndexOf("/") + 1, path2.indexOf(".json"));
                    if (!ResourceUtil.AllowedValues.isValid(dragon, true)) continue;
                    try {
                        JsonArray array = GsonHelper.m_13933_((JsonObject)((JsonObject)element), (String)"redirects");
                        for (int i = 0; i < array.size(); ++i) {
                            String eggModel;
                            JsonObject input = array.get(i).getAsJsonObject();
                            String string2 = eggModel = input.has("egg_item_model") ? input.get("egg_item_model").getAsString() : null;
                            if (eggModel == null) continue;
                            String name = input.get("name").getAsString();
                            redirects.put(name, eggModel);
                        }
                    }
                    catch (JsonIOException e) {
                        IoBVariantLoader.LOGGER.error("Failed to read json " + String.valueOf(id), (Throwable)e);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                    continue;
                }
            }
            catch (Exception e) {
                IoBVariantLoader.LOGGER.error("Error occurred while loading resource json " + String.valueOf(id), (Throwable)e);
            }
            if (redirects.isEmpty()) continue;
            ModelRedirectUtil.addEggItemModels(dragon, redirects);
        }
    }

    private static boolean shouldApplyFix(ADragonBase dragon, String dragonID, String name, StringArgument argument) {
        boolean texturePresent = ResourceUtil.isValid(ModelRedirectUtil.getCustomTexturePath(dragon, dragonID));
        boolean absentRecord = !dragonModelRedirects.containsKey(dragonID) || !dragonModelRedirects.get(dragonID).containsKey(name);
        boolean absentArgument = dragonModelRedirects.containsKey(dragonID) && dragonModelRedirects.get(dragonID).containsKey(name) && argument.getString().isEmpty();
        return texturePresent && (absentRecord || absentArgument);
    }

    private static interface StringArgument {
        public String getString();
    }
}

