/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.extras;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.extras.Extras;
import org.jetbrains.annotations.Nullable;

public class ExtrasUtil {
    public static final Map<String, Map<String, Extras>> extrasMap = new HashMap<String, Map<String, Extras>>();

    public static synchronized void add(String dragon, Map<String, Extras> extras) {
        Map<String, Extras> content = extrasMap.get(dragon);
        if (content != null) {
            content.putAll(extras);
            extrasMap.put(dragon, content);
        } else {
            extrasMap.put(dragon, extras);
        }
    }

    @Nullable
    public static String getLootTableRedirect(String dragon, String variant) {
        Map<String, Extras> extras;
        if (extrasMap.containsKey(dragon) && (extras = extrasMap.get(dragon)).containsKey(variant)) {
            return extras.get(variant).lootTableRedirect().orElse(null);
        }
        return null;
    }

    @Nullable
    public static String getVariandGroup(String dragon, String variant) {
        Map<String, Extras> extras;
        if (extrasMap.containsKey(dragon) && (extras = extrasMap.get(dragon)).containsKey(variant)) {
            return extras.get(variant).variantGroup().orElse(null);
        }
        return null;
    }

    public static void debugPrint() {
        if (!((Boolean)IoBVariantLoader.config.logExtras.get()).booleanValue()) {
            return;
        }
        for (Map.Entry<String, Map<String, Extras>> entry : extrasMap.entrySet()) {
            for (Map.Entry<String, Extras> extrasEntry : entry.getValue().entrySet()) {
                StringBuilder info = new StringBuilder();
                Extras extra = extrasEntry.getValue();
                extra.variantGroup().ifPresent(c -> info.append("Variant Group: ").append((String)c).append("\n"));
                extra.lootTableRedirect().ifPresent(c -> info.append("Loot Table Redirect: ").append((String)c).append("\n"));
                extra.variantAttributeModifiers().ifPresent(c -> {
                    info.append("Attribute Modifiers: ").append("\n");
                    c.forEach(modifier -> {
                        info.append("- Id: ").append(modifier.id()).append("\n");
                        info.append("- Amount: ").append(modifier.amount()).append("\n");
                        info.append("- Operation: ").append(modifier.operation()).append("\n");
                        info.append("\n");
                    });
                });
                extra.breedingItems().ifPresent(items -> {
                    info.append("Breeding Items: \n");
                    List<String> itemsById = items.itemsById();
                    List<String> itemsByTag = items.itemsByTag();
                    if (!itemsById.isEmpty()) {
                        info.append("- Items by ID: ");
                        itemsById.forEach(id -> info.append((String)id).append(" "));
                        info.append("\n");
                    }
                    if (!itemsByTag.isEmpty()) {
                        info.append("- Items by tag: ");
                        itemsByTag.forEach(id -> info.append((String)id).append(" "));
                        info.append("\n");
                    }
                });
                extra.tamingItems().ifPresent(items -> {
                    info.append("Taming Items: \n");
                    List<String> itemsById = items.itemsById();
                    List<String> itemsByTag = items.itemsByTag();
                    if (!itemsById.isEmpty()) {
                        info.append("- Items by ID: ");
                        itemsById.forEach(id -> info.append((String)id).append(" "));
                        info.append("\n");
                    }
                    if (!itemsByTag.isEmpty()) {
                        info.append("- Items by tag: ");
                        itemsByTag.forEach(id -> info.append((String)id).append(" "));
                        info.append("\n");
                    }
                });
                IoBVariantLoader.LOGGER.info("{}: variant {} was redirected to:\n{}", new Object[]{entry.getKey(), extrasEntry.getKey(), info});
            }
        }
    }

    @Nullable
    public static List<Extras.VariantAttributeModifier> getVariantAttributeModifiers(String dragon, String variant) {
        Map<String, Extras> extras;
        if (extrasMap.containsKey(dragon) && (extras = extrasMap.get(dragon)).containsKey(variant)) {
            return extras.get(variant).variantAttributeModifiers().orElse(null);
        }
        return null;
    }

    @Nullable
    public static Boolean isTamingItem(String dragon, String variant, ItemStack stack) {
        Map<String, Extras> extras;
        if (extrasMap.containsKey(dragon) && (extras = extrasMap.get(dragon)).containsKey(variant) && extras.get(variant).tamingItems().isPresent()) {
            return ExtrasUtil.isItemInList(extras.get(variant).tamingItems().get(), stack);
        }
        return null;
    }

    @Nullable
    public static Boolean isBreedingItem(String dragon, String variant, ItemStack stack) {
        Map<String, Extras> extras;
        if (extrasMap.containsKey(dragon) && (extras = extrasMap.get(dragon)).containsKey(variant) && extras.get(variant).breedingItems().isPresent()) {
            return ExtrasUtil.isItemInList(extras.get(variant).breedingItems().get(), stack);
        }
        return null;
    }

    private static boolean isItemInList(Extras.ItemRestriction restriction, ItemStack stack) {
        ResourceLocation name;
        boolean isIn = false;
        for (String s : restriction.itemsById()) {
            name = new ResourceLocation(s);
            if (!stack.m_41720_().m_204114_().m_205785_().m_135782_().equals((Object)name)) continue;
            isIn = true;
            break;
        }
        if (!isIn) {
            for (String tag : restriction.itemsByTag()) {
                name = new ResourceLocation(tag);
                if (!stack.m_204117_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)name))) continue;
                isIn = true;
                break;
            }
        }
        return isIn;
    }
}

