/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.ducks;

import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.ducks.ModelCacheHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;

public interface DragonEggModelHelper<T extends ADragonEggBase> {
    default public ResourceLocation getDefaultModel() {
        return new ResourceLocation("isleofberk", "geo/egg/" + this.defaultEggModel() + ".geo.json");
    }

    default public ResourceLocation getDefaultTexture(T entity) {
        return new ResourceLocation("isleofberk", "textures/egg/" + ModelRedirectUtil.getEggFolder(entity) + "/" + this.defaultEggTexture(entity) + ".png");
    }

    public String defaultEggModel();

    default public String defaultEggTexture(T entity) {
        ResourceLocation resourcelocation = EntityType.m_20613_((EntityType)entity.m_6095_());
        return switch (resourcelocation.m_135815_()) {
            default -> "";
            case "nadder_egg" -> "egg_nadder";
            case "gronckle_egg" -> "egg_gronk";
            case "light_fury_egg" -> "light_fury_egg";
            case "m_nightmare_egg" -> "egg_nightmare";
            case "night_fury_egg" -> "egg_night_fury";
            case "night_light_egg" -> "egg_night_light";
            case "skrill_egg" -> "egg_skrill";
            case "speed_stinger_egg" -> {
                switch (((VariantNameHelper)entity).getVariantName()) {
                    default: {
                        yield "egg_speed_stinger_0";
                    }
                    case "floutscout": {
                        yield "egg_floutscout_1";
                    }
                    case "ice_breaker": {
                        yield "egg_ice_breaker_2";
                    }
                    case "sweet_sting": 
                }
                yield "egg_sweet_sting_3";
            }
            case "stinger_egg" -> "wildroar_1";
            case "terrible_terror_egg" -> "terrible_terror_egg";
            case "triple_stryke_egg" -> "triple_stryke_egg";
            case "zippleback_egg" -> "egg_zippleback";
        };
    }

    default public ResourceLocation getModelLocationCache(T entity) {
        return ((ModelCacheHelper)entity).getModelLocationCache();
    }

    default public ResourceLocation getTextureLocationCache(T entity) {
        return ((ModelCacheHelper)entity).getTextureLocationCache();
    }

    default public void setModelLocationCache(T entity, ResourceLocation state) {
        ((ModelCacheHelper)entity).setModelLocationCache(state);
    }

    default public void setTextureLocationCache(T entity, ResourceLocation state) {
        ((ModelCacheHelper)entity).setTextureLocationCache(state);
    }

    default public ResourceLocation getCustomTexture(T entity) {
        return ModelRedirectUtil.getEggTexture(entity);
    }

    default public ResourceLocation getCustomModel(T entity) {
        return ModelRedirectUtil.getEggModel(entity);
    }

    default public ResourceLocation getModel(T entity) {
        if (!ResourceUtil.isResourceReloadFinished) {
            return this.getDefaultModel();
        }
        if (this.getModelLocationCache(entity) != null) {
            return this.getModelLocationCache(entity);
        }
        ResourceLocation id = this.getCustomModel(entity);
        if (ResourceUtil.isValid(id)) {
            this.setModelLocationCache(entity, id);
            return id;
        }
        this.setModelLocationCache(entity, this.getDefaultModel());
        return this.getDefaultModel();
    }

    default public ResourceLocation getTexture(T entity) {
        if (!ResourceUtil.isResourceReloadFinished) {
            return this.getDefaultTexture(entity);
        }
        if (this.getTextureLocationCache(entity) != null) {
            return this.getTextureLocationCache(entity);
        }
        ResourceLocation id = this.getCustomTexture(entity);
        if (ResourceUtil.isValid(id)) {
            this.setTextureLocationCache(entity, id);
            return id;
        }
        this.setTextureLocationCache(entity, this.getDefaultTexture(entity));
        return this.getDefaultTexture(entity);
    }
}

