/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util.dragon_variant_spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public record DragonVariantSpawner(String name, int weight, int breedingWeight, @NotNull BiomeRestrictions allowedBiomes, @NotNull BiomeRestrictions bannedBiomes, AltitudeRestriction altitudeRestriction, SurfaceRestriction surfaceRestriction) {
    public static Codec<DragonVariantSpawner> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(DragonVariantSpawner::name), (App)Codec.INT.fieldOf("weight").forGetter(DragonVariantSpawner::weight), (App)Codec.INT.optionalFieldOf("breeding_weight", (Object)-1).forGetter(DragonVariantSpawner::breedingWeight), (App)BiomeRestrictions.CODEC.optionalFieldOf("allowed_biomes", (Object)new BiomeRestrictions(List.of(), List.of())).forGetter(DragonVariantSpawner::allowedBiomes), (App)BiomeRestrictions.CODEC.optionalFieldOf("banned_biomes", (Object)new BiomeRestrictions(List.of(), List.of())).forGetter(DragonVariantSpawner::bannedBiomes), (App)AltitudeRestriction.CODEC.optionalFieldOf("altitude", (Object)new AltitudeRestriction(-1000, 1000)).forGetter(DragonVariantSpawner::altitudeRestriction), (App)SurfaceRestriction.CODEC.optionalFieldOf("surface_restriction", (Object)SurfaceRestriction.NONE).forGetter(DragonVariantSpawner::surfaceRestriction)).apply((Applicative)instance, (name, weight, breedingWeight, allowedBiomes, bannedBiomes, altitude, surfaceRestriction) -> {
        if (breedingWeight < 0) {
            breedingWeight = weight;
        }
        if (!allowedBiomes.hasBiomesByIdList() && !allowedBiomes.hasBiomesByTagList() && weight > 0) {
            allowedBiomes = new BiomeRestrictions(List.of(), List.of("forge:is_overworld"));
        }
        return new DragonVariantSpawner((String)name, (int)weight, (int)breedingWeight, (BiomeRestrictions)allowedBiomes, (BiomeRestrictions)bannedBiomes, (AltitudeRestriction)altitude, (SurfaceRestriction)((Object)((Object)surfaceRestriction)));
    }));

    public boolean hasAllowedBiomes() {
        return this.allowedBiomes.hasBiomesByIdList() || this.allowedBiomes.hasBiomesByTagList();
    }

    public boolean hasBannedBiomes() {
        return this.bannedBiomes.hasBiomesByIdList() || this.bannedBiomes.hasBiomesByTagList();
    }

    public record BiomeRestrictions(@NotNull List<String> biomesById, @NotNull List<String> biomesByTag) {
        public static Codec<BiomeRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("biome", List.of()).forGetter(BiomeRestrictions::biomesById), (App)Codec.STRING.listOf().optionalFieldOf("tag", List.of()).forGetter(BiomeRestrictions::biomesByTag)).apply((Applicative)instance, BiomeRestrictions::new));

        public boolean hasBiomesByIdList() {
            return !this.biomesById.isEmpty();
        }

        public boolean hasBiomesByTagList() {
            return !this.biomesByTag.isEmpty();
        }
    }

    public record AltitudeRestriction(int min, int max) {
        public static Codec<AltitudeRestriction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)-1000).forGetter(AltitudeRestriction::min), (App)Codec.INT.optionalFieldOf("max", (Object)1000).forGetter(AltitudeRestriction::max)).apply((Applicative)instance, AltitudeRestriction::new));
    }

    public static enum SurfaceRestriction {
        NONE(true, true),
        SURFACE(true, false),
        UNDERGROUND(false, true);

        private final boolean surfaceSpawn;
        private final boolean undergroundSpawn;
        public static Codec<SurfaceRestriction> CODEC;

        private SurfaceRestriction(boolean surfaceSpawn, boolean undergroundSpawn) {
            this.surfaceSpawn = surfaceSpawn;
            this.undergroundSpawn = undergroundSpawn;
        }

        public boolean canSpawn(BlockPos pos, ServerLevelAccessor level) {
            boolean surface = level.m_45527_(pos);
            return !surface && this.undergroundSpawn || surface && this.surfaceSpawn;
        }

        static {
            CODEC = ExtraCodecs.m_184405_(e -> e.name().toLowerCase(Locale.ROOT), name -> Enum.valueOf(SurfaceRestriction.class, name.toUpperCase(Locale.ROOT)));
        }
    }
}

