/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.util;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import org.jetbrains.annotations.NotNull;

public class ResourceUtil {
    public static boolean isResourceReloadFinished;
    private static final Map<String, String> letters;

    public static String parseName(ADragonBase dragon) {
        if (!dragon.m_8077_()) {
            return "";
        }
        String name = dragon.m_7755_().getString().toLowerCase();
        name = name.replace(" ", "_");
        if (!(name = ResourceUtil.replaceCyrillic(name)).matches("^[a-zA-Z0-9_]+$")) {
            name = "";
        }
        return name;
    }

    public static boolean isValid(ResourceLocation id) {
        return id != null && Minecraft.m_91087_().m_91098_().m_7165_(id);
    }

    private static String prepareVariantName(String name) {
        while (name.contains("_")) {
            int index = name.indexOf("_");
            if (index + 1 < name.length()) {
                String toReplace = String.valueOf(name.charAt(index + 1));
                name = name.replaceFirst("_" + toReplace, " " + toReplace.toUpperCase());
                continue;
            }
            name = name.replace("_", " ");
        }
        name = name.replace(" N ", "'n'");
        String firstLetter = String.valueOf(name.charAt(0));
        return name.replaceFirst(firstLetter, firstLetter.toUpperCase());
    }

    public static TranslatableComponent getVariantNameTooltip(@NotNull String variant, DragonSpeciesHelper helper) {
        if (((Boolean)IoBVariantLoader.clientConfig.displayOriginalVariantName.get()).booleanValue()) {
            return new TranslatableComponent("tooltip.iobvariantloader.variant", new Object[]{new TranslatableComponent(variant).m_130940_(ChatFormatting.GOLD)});
        }
        if (!variant.isEmpty()) {
            String key = "tooltip.iobvariantloader." + helper.getSpecies(true) + "." + variant;
            if (Language.m_128107_().m_6722_(key)) {
                return new TranslatableComponent("tooltip.iobvariantloader.variant", new Object[]{new TranslatableComponent(key).m_130940_(ChatFormatting.GOLD)});
            }
            variant = ResourceUtil.prepareVariantName(variant);
            return new TranslatableComponent("tooltip.iobvariantloader.variant", new Object[]{new TextComponent(variant).m_130940_(ChatFormatting.GOLD)});
        }
        return new TranslatableComponent("tooltip.iobvariantloader.variant", new Object[]{new TextComponent("unknown").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_178524_(Boolean.valueOf(true)))});
    }

    private static String replaceCyrillic(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            String l = text.substring(i, i + 1);
            sb.append(letters.getOrDefault(l, l));
        }
        return sb.toString();
    }

    static {
        letters = new HashMap<String, String>();
        letters.put("\u0430", "a");
        letters.put("\u0431", "b");
        letters.put("\u0432", "v");
        letters.put("\u0433", "g");
        letters.put("\u0434", "d");
        letters.put("\u0435", "e");
        letters.put("\u0451", "yo");
        letters.put("\u0436", "zh");
        letters.put("\u0437", "z");
        letters.put("\u0438", "i");
        letters.put("\u0439", "j");
        letters.put("\u043a", "k");
        letters.put("\u043b", "l");
        letters.put("\u043c", "m");
        letters.put("\u043d", "n");
        letters.put("\u043e", "o");
        letters.put("\u043f", "p");
        letters.put("\u0440", "r");
        letters.put("\u0441", "s");
        letters.put("\u0442", "t");
        letters.put("\u0443", "u");
        letters.put("\u0444", "f");
        letters.put("\u0445", "h");
        letters.put("\u0446", "c");
        letters.put("\u0447", "ch");
        letters.put("\u0448", "sh");
        letters.put("\u0449", "shch");
        letters.put("\u044c", "");
        letters.put("\u044b", "y");
        letters.put("\u044a", "");
        letters.put("\u044d", "e");
        letters.put("\u044e", "yu");
        letters.put("\u044f", "ya");
    }

    public static enum AllowedValues {
        DEADLY_NADDER("deadly_nadder"),
        GRONCKLE("gronckle"),
        LIGHT_FURY("light_fury"),
        MONSTROUS_NIGHTMARE("nightmare", "monstrous_nightmare"),
        NIGHT_FURY("night_fury"),
        NIGHT_LIGHT("night_light"),
        SKRILL("skrill"),
        SPEED_STINGER("speed_stinger"),
        SPEED_STINGER_LEADER("speed_stinger_leader"),
        STINGER("stinger"),
        TERRIBLE_TERROR("terrible_terror"),
        TRIPLE_STRYKE("triple_stryke"),
        ZIPPLEBACK("zippleback");

        private final String client;
        private final String server;

        private AllowedValues(String client, String server) {
            this.client = client;
            this.server = server;
        }

        private AllowedValues(String val) {
            this(val, val);
        }

        public static boolean isValid(String string, boolean isClient) {
            return Arrays.stream(AllowedValues.values()).anyMatch(allowedValues -> string.equals(isClient ? allowedValues.client : allowedValues.server));
        }
    }
}

