/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.common.egg;

import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.items.DragonEggItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawner;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawnerUtil;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import nordmods.iobvariantloader.util.ducks.ModelCacheHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ADragonEggBase.class})
public abstract class ADragonEggBaseMixin
extends AgeableMob
implements VariantNameHelper,
ModelCacheHelper,
DragonSpeciesHelper {
    @Unique
    private ResourceLocation modelLocationCache;
    @Unique
    private ResourceLocation textureLocationCache;
    @Unique
    private ResourceLocation glowLayerLocationCache;
    @Unique
    private boolean preventGlowLayer = false;
    @Unique
    private Component translationName;
    @Unique
    private static final EntityDataAccessor<String> VARIANT_NAME = SynchedEntityData.m_135353_(ADragonEggBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    @Shadow
    protected abstract DragonEggItem getItemVersion();

    @Shadow
    public abstract ResourceLocation getTextureLocation(ADragonEggBase var1);

    @Shadow
    public abstract Block getBlockParticle();

    @Shadow
    protected abstract int getHatchTime();

    @Shadow
    public abstract void setCanHatch(boolean var1);

    protected ADragonEggBaseMixin(EntityType<? extends AgeableMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Unique
    public String getVariantName() {
        return (String)this.f_19804_.m_135370_(VARIANT_NAME);
    }

    @Override
    @Unique
    public void setVariantName(String variantName) {
        this.f_19804_.m_135381_(VARIANT_NAME, (Object)variantName);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void saveVariantName(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128359_("VariantName", this.getVariantName());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readVariantName(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128441_("VariantName")) {
            this.setVariantName(nbt.m_128461_("VariantName"));
        }
    }

    @Inject(method={"defineSynchedData()V"}, at={@At(value="TAIL")})
    private void defineVariantName(CallbackInfo ci) {
        this.f_19804_.m_135372_(VARIANT_NAME, (Object)"");
    }

    @Redirect(method={"hatch()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean assignEggVariant(Level world, Entity entity) {
        if (world instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)world;
            if (this.getVariantName().isEmpty()) {
                DragonVariantSpawnerUtil.assignVariant(serverLevelAccessor, entity, false);
            } else {
                ((VariantNameHelper)entity).setVariantName(this.getVariantName());
            }
        }
        return world.m_7967_(entity);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (!this.m_146910_() && !this.f_19853_.m_5776_()) {
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
                DragonEggItem item = this.getItemVersion();
                ItemStack itemStack = new ItemStack((ItemLike)item);
                if (!this.getVariantName().isEmpty()) {
                    itemStack.m_41700_("VariantName", (Tag)StringTag.m_129297_((String)this.getVariantName()));
                }
                ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
                this.f_19853_.m_7967_((Entity)itemEntity);
            }
            this.m_146870_();
            return true;
        }
        return false;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setCanHatch(pReason != MobSpawnType.STRUCTURE);
        if (this.getVariantName().isEmpty() && ((Boolean)IoBVariantLoader.config.assignEggVariantOnPlaced.get()).booleanValue()) {
            List<DragonVariantSpawner> variants = DragonVariantSpawnerUtil.getVariantsFor(this.getSpecies(false));
            DragonVariantSpawnerUtil.assignVariantFromList(pLevel, (Entity)this, false, variants);
        }
        return pSpawnData;
    }

    @Override
    @Unique
    public String getSpecies(boolean isClient) {
        String dragonID;
        ResourceLocation resourcelocation = EntityType.m_20613_((EntityType)this.m_6095_());
        return switch (dragonID = resourcelocation.m_135815_().replace("_egg", "")) {
            default -> dragonID;
            case "m_nightmare" -> {
                if (isClient) {
                    yield "nightmare";
                }
                yield "monstrous_nightmare";
            }
            case "nadder" -> "deadly_nadder";
        };
    }

    public ItemStack m_142340_() {
        ItemStack itemStack = new ItemStack((ItemLike)this.getItemVersion());
        if (!this.getVariantName().isEmpty()) {
            itemStack.m_41700_("VariantName", (Tag)StringTag.m_129297_((String)this.getVariantName()));
        }
        return itemStack;
    }

    @Override
    public ResourceLocation getModelLocationCache() {
        return this.modelLocationCache;
    }

    @Override
    public ResourceLocation getTextureLocationCache() {
        return this.textureLocationCache;
    }

    @Override
    public ResourceLocation getGlowLayerLocationCache() {
        return this.glowLayerLocationCache;
    }

    @Override
    public void setModelLocationCache(ResourceLocation state) {
        this.modelLocationCache = state;
    }

    @Override
    public void setTextureLocationCache(ResourceLocation state) {
        this.textureLocationCache = state;
    }

    @Override
    public void setGlowLayerLocationCache(ResourceLocation state) {
        this.glowLayerLocationCache = state;
    }

    @Override
    public boolean shouldPreventGlowLayerRenderer() {
        return this.preventGlowLayer;
    }

    @Override
    public void setPreventGlowLayer(boolean state) {
        this.preventGlowLayer = state;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.m_5776_() && VARIANT_NAME.equals(key)) {
            this.resetCache();
        }
    }

    @Override
    public void resetTranslationName() {
        this.translationName = null;
    }

    protected Component m_5677_() {
        if (this.translationName == null) {
            String key = null;
            if (ModelRedirectUtil.dragonModelRedirects.containsKey(this.getSpecies(true)) && ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).containsKey(this.getVariantName())) {
                key = ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).get(this.getVariantName()).eggName().orElse(null);
            }
            this.translationName = key == null ? this.getDefaultTypeName() : new TranslatableComponent(key);
        }
        return this.translationName;
    }

    protected abstract Component getDefaultTypeName();
}

