/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.common.dragon;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.dragons.speedstinger.SpeedStinger;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.mixin.common.dragon.ADragonBaseMixin;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawnerUtil;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.extras.ExtrasUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirectUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib3.core.manager.AnimationData;

@Mixin(value={SpeedStinger.class})
public abstract class SpeedStingerMixin
extends ADragonBaseMixin {
    protected SpeedStingerMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Redirect(method={"spawnChildFromBreeding(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/animal/Animal;)V"}, at=@At(value="INVOKE", target="Lcom/GACMD/isleofberk/entity/dragons/speedstinger/SpeedStinger;getBreedEggResult(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lcom/GACMD/isleofberk/entity/eggs/entity/base/ADragonEggBase;"))
    private ADragonEggBase assignVariant(SpeedStinger instance, ServerLevel world, AgeableMob parent) {
        if (parent instanceof ADragonBase) {
            ADragonBase dragonPartner = (ADragonBase)parent;
            ADragonEggBase egg = instance.getBreedEggResult(world, (AgeableMob)dragonPartner);
            if (!((Boolean)IoBVariantLoader.config.assignEggVariantOnBreeding.get()).booleanValue()) {
                return egg;
            }
            if (egg instanceof VariantNameHelper) {
                VariantNameHelper helper = (VariantNameHelper)egg;
                if (instance instanceof VariantNameHelper) {
                    VariantNameHelper parent1 = (VariantNameHelper)instance;
                    if (dragonPartner instanceof VariantNameHelper) {
                        VariantNameHelper parent2 = (VariantNameHelper)dragonPartner;
                        String parent1Variant = parent1.getVariantName();
                        String parent2Variant = parent2.getVariantName();
                        if (instance.m_21187_().nextDouble() < (Double)IoBVariantLoader.config.inheritanceChance.get()) {
                            if (instance.m_21187_().nextBoolean()) {
                                helper.setVariantName(parent1Variant);
                            } else {
                                helper.setVariantName(parent2Variant);
                            }
                        } else {
                            DragonVariantSpawnerUtil.assignVariant((ServerLevelAccessor)world, (Entity)egg, false, parent1);
                        }
                        return egg;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getFromBaseVariant() {
        return switch (this.getDragonVariant()) {
            case 1 -> "floutscout";
            case 2 -> "ice_breaker";
            case 3 -> "sweet_sting";
            default -> "speed_stinger";
        };
    }

    @Override
    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void swapDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "death")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"get1stAttackSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapBiteSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "bite")) {
            cir.setReturnValue(null);
        }
    }

    @Override
    @Inject(method={"get2ndAttackSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapStingSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "sting")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"registerControllers"}, at={@At(value="TAIL")}, remap=false)
    private void registerSoundController(AnimationData data, CallbackInfo ci) {
        try {
            Class<?> clazz = data.getClass();
            String methodName = "getAnimationControllers";
            Method method = clazz.getMethod(methodName, new Class[0]);
            Map result = (Map)method.invoke((Object)data, new Object[0]);
            result.forEach((name, contr) -> contr.registerSoundListener(event -> SoundRedirectUtil.playSound(this, event.sound)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject(method={"isItemStackForTaming"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getTamingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isTamingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }

    @Inject(method={"isBreedingFood"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getBreedingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isBreedingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }
}

