/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.common.dragon;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.dragons.gronckle.Gronckle;
import com.GACMD.isleofberk.entity.dragons.stinger.Stinger;
import com.GACMD.isleofberk.entity.dragons.triple_stryke.TripleStryke;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.NightLightEgg;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawner;
import nordmods.iobvariantloader.util.dragon_variant_spawner.DragonVariantSpawnerUtil;
import nordmods.iobvariantloader.util.ducks.AttackBoxRedirectHelper;
import nordmods.iobvariantloader.util.ducks.DefaultVariantNameHelper;
import nordmods.iobvariantloader.util.ducks.DragonModelCacheHelper;
import nordmods.iobvariantloader.util.ducks.DragonSpeciesHelper;
import nordmods.iobvariantloader.util.ducks.HitboxRedirectHelper;
import nordmods.iobvariantloader.util.ducks.ModelSizeProvider;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.extras.Extras;
import nordmods.iobvariantloader.util.extras.ExtrasUtil;
import nordmods.iobvariantloader.util.hitbox_redirect.HitboxRedirectUtil;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;
import nordmods.iobvariantloader.util.sound_redirect.SoundRedirectUtil;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ADragonBase.class})
public abstract class ADragonBaseMixin
extends TamableAnimal
implements VariantNameHelper,
DragonModelCacheHelper,
DragonSpeciesHelper,
HitboxRedirectHelper,
ModelSizeProvider,
DefaultVariantNameHelper {
    @Unique
    private ResourceLocation modelLocationCache;
    @Unique
    private ResourceLocation textureLocationCache;
    @Unique
    private ResourceLocation animationLocationCache;
    @Unique
    private ResourceLocation saddleTextureLocationCache;
    @Unique
    private ResourceLocation glowLayerLocationCache;
    @Unique
    private boolean preventGlowLayer = false;
    @Unique
    private Component translationName;
    @Unique
    private EntityDimensions boxOverride;
    @Unique
    private EntityDimensions attackBoxOverride;
    @Unique
    private Vec3 attackBoxPos;
    @Unique
    private static final UUID VARIANT_BONUS_MODIFIER = UUID.fromString("7c152c39-d158-48ae-92c7-2655c8072705");
    @Unique
    private Float ogHealth;
    @Unique
    private static final EntityDataAccessor<String> VARIANT_NAME = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    @Shadow
    public abstract int getDragonVariant();

    @Shadow
    public abstract boolean isTitanWing();

    @Shadow
    public abstract double m_20165_(double var1);

    @Shadow
    public abstract double m_20227_(double var1);

    @Shadow
    public abstract double m_20246_(double var1);

    protected ADragonBaseMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Unique
    public String getVariantName() {
        return (String)this.f_19804_.m_135370_(VARIANT_NAME);
    }

    @Override
    @Unique
    public void setVariantName(String variantName) {
        this.f_19804_.m_135381_(VARIANT_NAME, (Object)variantName);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void saveVariantName(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128359_("VariantName", this.getVariantName());
        String group = ExtrasUtil.getVariandGroup(this.getSpecies(false), this.getVariantName());
        if (group != null) {
            nbt.m_128359_("VariantGroup", group);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void setOgHealth(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128441_("Health")) {
            this.ogHealth = Float.valueOf(nbt.m_128457_("Health"));
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readVariantName(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128441_("VariantName")) {
            this.setVariantName(nbt.m_128461_("VariantName"));
        } else {
            this.setVariantName(this.getFromBaseVariant());
        }
    }

    @Inject(method={"defineSynchedData()V"}, at={@At(value="TAIL")})
    private void defineVariantName(CallbackInfo ci) {
        this.f_19804_.m_135372_(VARIANT_NAME, (Object)"");
    }

    @Inject(method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/entity/SpawnGroupData;"}, at={@At(value="HEAD")})
    private void assignVariantName(ServerLevelAccessor world, DifficultyInstance p_146747_, MobSpawnType p_146748_, SpawnGroupData p_146749_, CompoundTag p_146750_, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (this.getVariantName().isEmpty()) {
            DragonVariantSpawnerUtil.assignVariant(world, (Entity)this, true);
        }
        this.m_21153_(this.m_21233_());
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (f_19833_.equals(key) || VARIANT_NAME.equals(key) || f_146731_.equals(key)) {
            if (this.f_19853_.m_5776_()) {
                this.resetCache();
            }
            this.removeVariantModifiers();
            this.applyVariantModifiers();
            if (this.ogHealth != null) {
                this.m_21153_(this.ogHealth.floatValue());
                this.ogHealth = null;
            }
            this.resetHitboxData();
        }
    }

    @Override
    public void resetTranslationName() {
        this.translationName = null;
    }

    @Override
    public ResourceLocation getModelLocationCache() {
        return this.modelLocationCache;
    }

    @Override
    public ResourceLocation getAnimationLocationCache() {
        return this.animationLocationCache;
    }

    @Override
    public ResourceLocation getTextureLocationCache() {
        return this.textureLocationCache;
    }

    @Override
    public ResourceLocation getSaddleTextureLocationCache() {
        return this.saddleTextureLocationCache;
    }

    @Override
    public ResourceLocation getGlowLayerLocationCache() {
        return this.glowLayerLocationCache;
    }

    @Override
    public void setModelLocationCache(ResourceLocation state) {
        this.modelLocationCache = state;
    }

    @Override
    public void setAnimationLocationCache(ResourceLocation state) {
        this.animationLocationCache = state;
    }

    @Override
    public void setTextureLocationCache(ResourceLocation state) {
        this.textureLocationCache = state;
    }

    @Override
    public void setSaddleTextureLocationCache(ResourceLocation state) {
        this.saddleTextureLocationCache = state;
    }

    @Override
    public void setGlowLayerLocationCache(ResourceLocation state) {
        this.glowLayerLocationCache = state;
    }

    @Override
    public boolean shouldPreventGlowLayerRenderer() {
        return this.preventGlowLayer;
    }

    @Override
    public void setPreventGlowLayer(boolean state) {
        this.preventGlowLayer = state;
    }

    @Redirect(method={"spawnChildFromBreeding(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/animal/Animal;)V"}, at=@At(value="INVOKE", target="Lcom/GACMD/isleofberk/entity/base/dragon/ADragonBase;getBreedEggResult(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lcom/GACMD/isleofberk/entity/eggs/entity/base/ADragonEggBase;"), remap=false)
    private ADragonEggBase assignVariant(ADragonBase instance, ServerLevel world, AgeableMob parent) {
        if (parent instanceof ADragonBase) {
            ADragonBase dragonPartner = (ADragonBase)parent;
            ADragonEggBase egg = instance.getBreedEggResult(world, (AgeableMob)dragonPartner);
            if (!((Boolean)IoBVariantLoader.config.assignEggVariantOnBreeding.get()).booleanValue()) {
                return egg;
            }
            if (egg instanceof VariantNameHelper) {
                VariantNameHelper helper = (VariantNameHelper)egg;
                if (instance instanceof VariantNameHelper) {
                    VariantNameHelper parent1 = (VariantNameHelper)instance;
                    if (dragonPartner instanceof VariantNameHelper) {
                        VariantNameHelper parent2 = (VariantNameHelper)dragonPartner;
                        String parent1Variant = parent1.getVariantName();
                        String parent2Variant = parent2.getVariantName();
                        if (instance.m_21187_().nextDouble() < (Double)IoBVariantLoader.config.inheritanceChance.get()) {
                            DragonVariantSpawner variant1 = DragonVariantSpawnerUtil.getVariantByName(parent1, parent1Variant);
                            DragonVariantSpawner variant2 = DragonVariantSpawnerUtil.getVariantByName(parent2, parent2Variant);
                            if (variant1 != null && variant2 != null) {
                                int weight1 = variant1.breedingWeight();
                                int weight2 = variant2.breedingWeight();
                                if (weight1 > 0 || weight2 > 0) {
                                    if (weight1 <= 0) {
                                        helper.setVariantName(parent2Variant);
                                    } else if (weight2 <= 0) {
                                        helper.setVariantName(parent1Variant);
                                    } else if (this.m_21187_().nextInt(weight1 + weight2) < weight1) {
                                        helper.setVariantName(parent1Variant);
                                    } else {
                                        helper.setVariantName(parent2Variant);
                                    }
                                }
                            }
                            if (variant1 == null && variant2 != null) {
                                helper.setVariantName(parent2Variant);
                            } else if (variant2 == null && variant1 != null) {
                                helper.setVariantName(parent1Variant);
                            }
                        }
                        if (helper.getVariantName().isEmpty()) {
                            DragonVariantSpawnerUtil.assignVariant((ServerLevelAccessor)world, (Entity)egg, false, parent1);
                        }
                        return egg;
                    }
                }
            }
        }
        return null;
    }

    @ModifyArg(method={"spawnChildFromBreeding(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/animal/Animal;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private Entity assignNightLightVariant(Entity egg) {
        Level level;
        VariantNameHelper helper;
        if (!((Boolean)IoBVariantLoader.config.assignEggVariantOnBreeding.get()).booleanValue()) {
            return egg;
        }
        if (egg instanceof VariantNameHelper && (helper = (VariantNameHelper)egg).getVariantName().isEmpty() && egg instanceof NightLightEgg && (level = this.f_19853_) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
            List<DragonVariantSpawner> variants = DragonVariantSpawnerUtil.getVariantsFor("night_light");
            DragonVariantSpawnerUtil.assignVariantFromList(serverLevelAccessor, egg, false, variants);
        }
        return egg;
    }

    protected Component m_5677_() {
        if (this.f_19853_.m_5776_() && !ResourceUtil.isResourceReloadFinished) {
            return super.m_5677_();
        }
        if (this.translationName == null) {
            String key = null;
            if (ModelRedirectUtil.dragonModelRedirects.containsKey(this.getSpecies(true)) && ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).containsKey(this.getVariantName())) {
                key = ModelRedirectUtil.dragonModelRedirects.get(this.getSpecies(true)).get(this.getVariantName()).dragonName().orElse(null);
            }
            this.translationName = key == null ? super.m_5677_() : new TranslatableComponent(key);
        }
        return this.translationName;
    }

    @Override
    @Unique
    public String getSpecies(boolean isClient) {
        String dragonID = EntityType.m_20613_((EntityType)this.m_6095_()).m_135815_();
        if (isClient && dragonID.equals("monstrous_nightmare")) {
            return "nightmare";
        }
        return dragonID;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions override;
        if (this.boxOverride == null) {
            EntityDimensions original = super.m_6972_(pPose);
            override = HitboxRedirectUtil.getHitboxOverride((ADragonBase)this);
            EntityDimensions entityDimensions = this.boxOverride = override == null ? original : override.m_20388_(this.m_6134_());
        }
        if (this.getParts() != null && (override = this.getParts()[0]) instanceof AttackBoxRedirectHelper) {
            AttackBoxRedirectHelper helper = (AttackBoxRedirectHelper)override;
            EntityDimensions newBox = this.getAttackBox();
            if (newBox != this.getParts()[0].m_6972_(pPose)) {
                helper.setAttackBoxOverride(newBox);
                this.getParts()[0].m_6210_();
            }
        }
        return this.boxOverride;
    }

    @Override
    public void resetHitboxData() {
        this.boxOverride = null;
        this.attackBoxPos = null;
        this.attackBoxOverride = null;
        this.m_6210_();
    }

    @Override
    public EntityDimensions getAttackBox() {
        if (this.getVariantName().isEmpty()) {
            return this.getDefaultAttackBox((ADragonBase)this);
        }
        if (this.attackBoxOverride == null) {
            this.attackBoxOverride = HitboxRedirectUtil.getAttackBoxOverride((ADragonBase)this);
            if (this.attackBoxOverride == null) {
                this.attackBoxOverride = this.getDefaultAttackBox((ADragonBase)this);
            }
        }
        return this.attackBoxOverride;
    }

    @Override
    public Vec3 getAttackBoxPos() {
        if (this.getVariantName().isEmpty()) {
            return this.getDefaultAttackBoxPos((ADragonBase)this);
        }
        if (this.attackBoxPos == null) {
            this.attackBoxPos = HitboxRedirectUtil.getAttackBoxPos((ADragonBase)this);
            if (this.attackBoxPos == null) {
                this.attackBoxPos = this.getDefaultAttackBoxPos((ADragonBase)this);
            }
        }
        return this.attackBoxPos;
    }

    private Vec3 getDefaultAttackBoxPos(ADragonBase dragon) {
        if (dragon instanceof Gronckle) {
            return new Vec3(2.2, 0.4, 2.2);
        }
        if (dragon instanceof TripleStryke) {
            return new Vec3(3.0, 0.4, 3.0);
        }
        if (dragon instanceof Stinger) {
            Stinger stinger = (Stinger)dragon;
            return new Vec3(3.0, stinger.isUsingAbility() ? 0.4 : 2.0, 3.0);
        }
        return Vec3.f_82478_;
    }

    private EntityDimensions getDefaultAttackBox(ADragonBase dragon) {
        if (dragon instanceof Gronckle) {
            return EntityDimensions.m_20395_((float)1.6f, (float)1.6f);
        }
        if (dragon instanceof TripleStryke) {
            return EntityDimensions.m_20395_((float)1.8f, (float)1.8f);
        }
        if (dragon instanceof Stinger) {
            return EntityDimensions.m_20395_((float)1.5f, (float)1.5f);
        }
        return EntityDimensions.m_20395_((float)1.0f, (float)1.0f);
    }

    @Override
    public float getModelSize() {
        String species = this.getSpecies(true);
        if (this.m_6162_()) {
            return switch (species) {
                case "terrible_terror" -> 0.3f;
                default -> 0.4f;
            };
        }
        if (this.isTitanWing()) {
            return switch (species) {
                case "terrible_terror" -> 1.0f;
                default -> 1.4f;
            };
        }
        return switch (species) {
            case "night_fury" -> 1.1f;
            case "skrill" -> 1.4f;
            case "terrible_terror" -> 0.7f;
            case "triple_stryke" -> 1.3f;
            case "speed_stinger_leader" -> 1.4f;
            default -> 1.0f;
        };
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return 0.0f;
    }

    public void m_8032_() {
        if (!SoundRedirectUtil.playSound(this, this.m_5803_() ? "sleep" : "growl")) {
            super.m_8032_();
        }
    }

    @Inject(method={"playHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void swapHurtSound(DamageSource pSource, CallbackInfo ci) {
        if (SoundRedirectUtil.playSound(this, "hurt")) {
            ci.cancel();
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void swapDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "death")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getTameSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapTameSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "tame")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"get1stAttackSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapBiteSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "bite")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"get2ndAttackSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapStingSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "sting")) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getProjectileSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void swapFireSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (SoundRedirectUtil.playSound(this, "fire")) {
            cir.setReturnValue(null);
        }
    }

    public void m_7355_(BlockPos pos, BlockState state) {
        if (!SoundRedirectUtil.playSound(this, "step")) {
            super.m_7355_(pos, state);
        }
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        String lootTable = ExtrasUtil.getLootTableRedirect(this.getSpecies(false), this.getVariantName());
        return lootTable != null ? new ResourceLocation(lootTable) : super.m_7582_();
    }

    @Unique
    private void applyVariantModifiers() {
        List<Extras.VariantAttributeModifier> modifiers = ExtrasUtil.getVariantAttributeModifiers(this.getSpecies(false), this.getVariantName());
        if (modifiers == null) {
            return;
        }
        modifiers.forEach(modifier -> {
            Attribute attribute = (Attribute)((Registry)this.m_183503_().m_5962_().m_6632_(Registry.f_122916_).get()).m_7745_(new ResourceLocation(modifier.id()));
            if (attribute == null) {
                IoBVariantLoader.LOGGER.warn("Failed to find attribute {} for {} for variant {}. Modifier will not be applied", new Object[]{modifier.id(), this.getSpecies(false), this.getVariantName()});
                return;
            }
            AttributeInstance instance = this.m_21051_(attribute);
            AttributeModifier attributeModifier = new AttributeModifier(VARIANT_BONUS_MODIFIER, "Variant Bonus", modifier.amount(), AttributeModifier.Operation.valueOf((String)modifier.operation()));
            if (instance != null && !instance.m_22109_(attributeModifier)) {
                instance.m_22118_(attributeModifier);
            }
        });
    }

    @Unique
    private void removeVariantModifiers() {
        AttributeMap container = this.m_21204_();
        this.m_183503_().m_5962_().m_6632_(Registry.f_122916_).ifPresent(registry -> registry.forEach(attribute -> {
            if (container.m_22171_(attribute)) {
                container.m_22146_(attribute).m_22120_(VARIANT_BONUS_MODIFIER);
            }
        }));
    }

    @Inject(method={"isItemStackForTaming"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getTamingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isTamingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }

    @Inject(method={"isBreedingFood"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getBreedingItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Boolean isCorrect = ExtrasUtil.isBreedingItem(this.getSpecies(false), this.getVariantName(), stack);
        if (isCorrect != null) {
            cir.setReturnValue((Object)isCorrect);
        }
    }
}

