/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.mixin.client.isleofberk.dragon;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModel;
import net.minecraft.resources.ResourceLocation;
import nordmods.iobvariantloader.IoBVariantLoader;
import nordmods.iobvariantloader.util.ResourceUtil;
import nordmods.iobvariantloader.util.ducks.DragonModelCacheHelper;
import nordmods.iobvariantloader.util.ducks.VariantNameHelper;
import nordmods.iobvariantloader.util.model_redirect.ModelRedirectUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import software.bernie.geckolib3.model.AnimatedGeoModel;

@Mixin(value={BaseDragonModel.class})
public abstract class BaseDragonModelMixin<T extends ADragonBase>
extends AnimatedGeoModel<T> {
    @Shadow
    protected abstract float getBabySize();

    @Shadow
    protected abstract float getAdultSize();

    @Shadow
    protected abstract float getTitanSize();

    public ResourceLocation getModelLocation(T entity) {
        ResourceLocation id;
        if (!ResourceUtil.isResourceReloadFinished) {
            return this.getDefaultModel();
        }
        if (this.getModelLocationCache(entity) != null) {
            return this.getModelLocationCache(entity);
        }
        if (!((Boolean)IoBVariantLoader.clientConfig.disableNamedVariants.get()).booleanValue() && ResourceUtil.isValid(id = ModelRedirectUtil.getCustomModelPath(entity, this.getDragonFolder())) && ModelRedirectUtil.isNametagAccessible(this.getDragonFolder(), ResourceUtil.parseName(entity))) {
            this.setModelLocationCache(entity, id);
            return id;
        }
        id = ModelRedirectUtil.getVariantModelPath(entity, this.getDragonFolder());
        if (ResourceUtil.isValid(id)) {
            this.setModelLocationCache(entity, id);
            return id;
        }
        this.setModelLocationCache(entity, this.getDefaultModel());
        return this.getDefaultModel();
    }

    public ResourceLocation getTextureLocation(T entity) {
        ResourceLocation id;
        if (!ResourceUtil.isResourceReloadFinished) {
            return this.getDefaultVariant();
        }
        if (this.getTextureLocationCache(entity) != null) {
            return this.getTextureLocationCache(entity);
        }
        if (!((Boolean)IoBVariantLoader.clientConfig.disableNamedVariants.get()).booleanValue() && ResourceUtil.isValid(id = this.getCustomTexture(entity)) && ModelRedirectUtil.isNametagAccessible(this.getDragonFolder(), ResourceUtil.parseName(entity))) {
            this.setTextureLocationCache(entity, id);
            return id;
        }
        id = this.getVariantTexture(entity);
        if (ResourceUtil.isValid(id)) {
            this.setTextureLocationCache(entity, id);
            return id;
        }
        this.setTextureLocationCache(entity, this.getDefaultVariant());
        return this.getDefaultVariant();
    }

    public ResourceLocation getAnimationFileLocation(T entity) {
        ResourceLocation id;
        if (!ResourceUtil.isResourceReloadFinished) {
            return this.getDefaultAnimation();
        }
        if (this.getAnimationLocationCache(entity) != null) {
            return this.getAnimationLocationCache(entity);
        }
        if (!((Boolean)IoBVariantLoader.clientConfig.disableNamedVariants.get()).booleanValue() && ResourceUtil.isValid(id = ModelRedirectUtil.getCustomAnimationPath(entity, this.getDragonFolder())) && ModelRedirectUtil.isNametagAccessible(this.getDragonFolder(), ResourceUtil.parseName(entity))) {
            this.setAnimationLocationCache(entity, id);
            return id;
        }
        id = ModelRedirectUtil.getVariantAnimationPath(entity, this.getDragonFolder());
        if (ResourceUtil.isValid(id)) {
            this.setAnimationLocationCache(entity, id);
            return id;
        }
        this.setAnimationLocationCache(entity, this.getDefaultAnimation());
        return this.getDefaultAnimation();
    }

    public ResourceLocation getDefaultModel() {
        return new ResourceLocation("isleofberk", "geo/dragons/" + this.getDragonFolder() + ".geo.json");
    }

    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("isleofberk", "textures/dragons/" + this.getDragonFolder() + "/" + this.getDefaultTexture() + ".png");
    }

    public ResourceLocation getDefaultAnimation() {
        return new ResourceLocation("isleofberk", "animations/dragons/" + this.getDragonFolder() + ".animation.json");
    }

    public abstract String getDragonFolder();

    public abstract String getDefaultTexture();

    public ResourceLocation getModelLocationCache(T entity) {
        return ((DragonModelCacheHelper)entity).getModelLocationCache();
    }

    public ResourceLocation getAnimationLocationCache(T entity) {
        return ((DragonModelCacheHelper)entity).getAnimationLocationCache();
    }

    public ResourceLocation getTextureLocationCache(T entity) {
        return ((DragonModelCacheHelper)entity).getTextureLocationCache();
    }

    public void setModelLocationCache(T entity, ResourceLocation state) {
        ((DragonModelCacheHelper)entity).setModelLocationCache(state);
    }

    public void setAnimationLocationCache(T entity, ResourceLocation state) {
        ((DragonModelCacheHelper)entity).setAnimationLocationCache(state);
    }

    public void setTextureLocationCache(T entity, ResourceLocation state) {
        ((DragonModelCacheHelper)entity).setTextureLocationCache(state);
    }

    public ResourceLocation getCustomTexture(T entity) {
        return ModelRedirectUtil.getCustomTexturePath(entity, this.getDragonFolder());
    }

    public ResourceLocation getVariantTexture(T entity) {
        return ModelRedirectUtil.getVariantTexturePath(((VariantNameHelper)entity).getVariantName(), this.getDragonFolder(), entity.m_6162_());
    }
}

