/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.events_on_client.ClientOnlyForgeSetup;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RotationsCPacket {
    private int[] value;
    private boolean setconfig;
    private UUID uuid;

    public RotationsCPacket(FriendlyByteBuf buf) {
        this.value = buf.m_130100_();
        this.setconfig = buf.readBoolean();
        this.uuid = buf.m_130259_();
    }

    public RotationsCPacket(int[] slotnum, boolean setConfigForClient, UUID uuid) {
        this.value = slotnum;
        this.setconfig = setConfigForClient;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130089_(this.value);
        buf.writeBoolean(this.setconfig);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (Player target : Minecraft.m_91087_().f_91073_.m_6907_()) {
            PlayerData data;
            if (!target.m_142081_().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null || this.value == null) continue;
            data.rotations = this.value;
            if (target != Minecraft.m_91087_().f_91074_ || !this.setconfig) continue;
            for (int i = 0; i < data.rotations.length; ++i) {
                try {
                    ConfigHolder.COMMON.rotations[i].set((Object)data.rotations[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ClientOnlyForgeSetup.slotRotations = data.rotations;
        }
    }
}

