/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class HandActionCPacket {
    private boolean value;
    private UUID uuid;

    public HandActionCPacket(FriendlyByteBuf buf) {
        this.value = buf.readBoolean();
        this.uuid = buf.m_130259_();
    }

    public HandActionCPacket(boolean slotnum, UUID uuid) {
        this.value = slotnum;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.value);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (Player target : Minecraft.m_91087_().f_91073_.m_6907_()) {
            PlayerData data;
            if (!target.m_142081_().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null) continue;
            if (this.value) {
                data.lastMainhandHit = 1;
                continue;
            }
            data.lastOffhandHit = 1;
        }
    }
}

