/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.helper;

import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.BlacklistCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.HideTickCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ItemStackCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.PositionsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.RotationsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ScaleCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SelectedSlotCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SlotAttachmentCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SlotMoverCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ToggleCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.UniqueItemSettingsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.WhitelistCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;

public class ServerHelper {
    public static ItemStack getProjectile(Player player, ItemStack p_36349_) {
        if (!(p_36349_.m_41720_() instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        Predicate predicate = ((ProjectileWeaponItem)p_36349_.m_41720_()).m_6442_();
        ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)player, (Predicate)predicate);
        if (!itemstack.m_41619_()) {
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)p_36349_, (ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)p_36349_.m_41720_()).m_6437_();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack1 = player.m_150109_().m_8020_(i);
            if (!predicate.test(itemstack1)) continue;
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)p_36349_, (ItemStack)itemstack1);
        }
        return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)p_36349_, (ItemStack)(player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : ItemStack.f_41583_));
    }

    public static void sendAllDataToClient(Player target, ServerPlayer player) {
        PlayerData data = ((IPlayerData)target).getPlayerData();
        if (data != null) {
            if (data.positions != null) {
                Networking.sendToClient(new PositionsCPacket(data.positions, false, target.m_142081_()), player);
            }
            if (data.rotations != null) {
                Networking.sendToClient(new RotationsCPacket(data.rotations, false, target.m_142081_()), player);
            }
            if (data.scale != null) {
                Networking.sendToClient(new ScaleCPacket(data.scale, false, target.m_142081_()), player);
            }
            if (data.toggleSlots != null) {
                Networking.sendToClient(new ToggleCPacket(data.toggleSlots, false, target.m_142081_()), player);
            }
            for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                if (data.inventory[i] == null) continue;
                Networking.sendToClient(new ItemStackCPacket(data.inventory[i], i, target.m_142081_()), player);
            }
            Networking.sendToClient(new HideTickCPacket(data.hideTick, false, target.m_142081_()), player);
            Networking.sendToClient(new SelectedSlotCPacket(data.selectedSlot, target.m_142081_()), player);
            if (data.slotAttachments != null) {
                Networking.sendToClient(new SlotAttachmentCPacket(data.slotAttachments, false, target.m_142081_()), player);
            }
            if (data.mover != null) {
                Networking.sendToClient(new SlotMoverCPacket(data.mover, false, target.m_142081_()), player);
            }
            if (data.blacklist != null) {
                Networking.sendToClient(new BlacklistCPacket(data.blacklist, false, target.m_142081_()), player);
            }
            if (data.whitelist != null) {
                Networking.sendToClient(new WhitelistCPacket(data.whitelist, false, target.m_142081_()), player);
            }
            if (data.uniqueItemDisplay != null) {
                Networking.sendToClient(new UniqueItemSettingsCPacket(data.uniqueItemDisplay, false, target.m_142081_()), player);
            }
        }
    }
}

