/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.events_on_server;

import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ItemStackCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SelectedSlotCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SendHandshakeCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="weaponmaster_ydm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        ((IPlayerData)event.getEntity()).setPlayerData(((IPlayerData)event.getOriginal()).getPlayerData());
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_183503_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Player target = event.getPlayer();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().m_183503_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Player target = event.getPlayer();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        if (!event.getEntity().m_183503_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Player target = (Player)event.getTarget();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            Networking.sendToClient(new SendHandshakeCPacket(player.m_142081_()), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerData data;
        Player player;
        if (event.phase == TickEvent.Phase.END && !event.player.m_183503_().m_5776_() && (player = event.player) != null && (data = ((IPlayerData)player).getPlayerData()) != null && player.m_150109_() != null) {
            if (player.m_150109_().f_35977_ != data.selectedSlot) {
                data.selectedSlot = player.m_150109_().f_35977_;
                for (Object sp : player.m_183503_().m_6907_()) {
                    if (!(sp.m_20280_((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new SelectedSlotCPacket(player.m_150109_().f_35977_, player.m_142081_()), (ServerPlayer)sp);
                }
            }
            for (int i = 0; i < 9; ++i) {
                if (player.m_150109_().m_8020_(i) == null || player.m_150109_().m_8020_(i).equals(data.inventory[i], false)) continue;
                data.inventory[i] = player.m_150109_().m_8020_(i).m_41777_();
                for (Player sp : player.m_183503_().m_6907_()) {
                    if (!(sp.m_20280_((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(data.inventory[i], i, player.m_142081_()), (ServerPlayer)sp);
                }
            }
            if (player.m_21206_() != null && !player.m_21206_().equals(data.inventory[9], false)) {
                data.inventory[9] = player.m_21206_().m_41777_();
                for (Object sp : player.m_183503_().m_6907_()) {
                    if (!(sp.m_20280_((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(data.inventory[9], 9, player.m_142081_()), (ServerPlayer)sp);
                }
            }
            boolean hasProjectileWeaponItem = false;
            for (int j = 0; j < 9; ++j) {
                if (data.inventory[j] == null || !(data.inventory[j].m_41720_() instanceof ProjectileWeaponItem)) continue;
                hasProjectileWeaponItem = true;
                ItemStack ammo = ServerHelper.getProjectile(player, data.inventory[j]);
                if (data.inventory[10].equals(ammo, false)) continue;
                data.inventory[10] = ammo.m_41777_();
                hasProjectileWeaponItem = true;
                for (Player sp : player.m_183503_().m_6907_()) {
                    if (!(sp.m_20280_((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(ammo, 10, player.m_142081_()), (ServerPlayer)sp);
                }
                break;
            }
            if (!hasProjectileWeaponItem && !data.inventory[10].equals(ItemStack.f_41583_, false)) {
                data.inventory[10] = ItemStack.f_41583_;
                for (Player sp : player.m_183503_().m_6907_()) {
                    if (!(sp.m_20280_((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(ItemStack.f_41583_, 10, player.m_142081_()), (ServerPlayer)sp);
                }
            }
        }
    }
}

